/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.localdb.statusdb.server;

import java.util.List;
import org.lsst.ccs.localdb.statusdb.model.MetaDataData;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

/**
 *
 * @author turri
 */
public class ChannelMetaData {
    
    @XmlAttribute
    private long tstart, tstop = -1;
    @XmlAttribute
    private String name, value;
    
    public ChannelMetaData(MetaDataData d) {
        this.name = d.getName();
        this.value = d.getValue();
        this.tstart = d.getStartTime();
        this.tstop = d.getEndTime();
    }

    public ChannelMetaData(){};

    public ChannelMetaData(String name, String value, long tstart, long tstop) {
        this.name = name;
        this.value = value;
        this.tstart = tstart;
        this.tstop = tstop;
    }

    public long getTstart() {
        return tstart;
    }

    public long getTstop() {
        return tstop;
    }

    public String getName() {
        return name;
    }

    public String getValue() {
        return value;
    }
    
    @XmlRootElement(name = "channelinfo")
    public static class ChannelMetadataList {
        
        @XmlElementWrapper(name = "channelmetadata")
        @XmlElement(name = "channelmetadatavalue")
        public List<ChannelMetaData> list;
        
        public ChannelMetadataList(List<ChannelMetaData> list) {
            this.list = list;
        }
        
        public ChannelMetadataList() {
        }
    }
    
}
