package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.trendServer.RestServer;

/**
 * Defines a data channel for trending analysis.
 * 
 */

public class DataChannel extends Channel implements Serializable {

	private static final long serialVersionUID = -9154127909107314678L;

	public DataChannel(DataDesc desc) {
		path = desc.getDataPath().getPath();
                setId(desc.getId());
	}

	public DataChannel() {
	}

	protected long id;
	
	@XmlElement
	public long getId() {
            return id;
	}
	
	public void setId(long id) {
		this.id = id;
	}

	// wrapper class to get the correct collection name
	
	@XmlRootElement(name="datachannels")
	public static class DataChannelList {

            @XmlElement(name = "datachannel")
            public List<DataChannel> list;

            @XmlAttribute
            private Date activeSinceDate;

            @XmlAttribute
            private String host;

            @XmlAttribute
            private int port;

            public DataChannelList(List<DataChannel> list, long milliseconds) {
                this.list = list;
                activeSinceDate = new Date(milliseconds);
                this.host = RestServer.getRestServerHost();
                this.port = RestServer.getRestServerPort();
            }

            public DataChannelList() {
            }

            public Date getActiveSinceDate() {
                return activeSinceDate;
            }
            
            public int getPort() {
                return port;
            }
            
            public String getHost() {
                return host;
            }
            
	}

}
