/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.localdb.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;

/**
 *
 * @author The LSST CCS Team
 *
 */
public class DropForeignKeyConstraint {

    /**
     * @param args the command line arguments
     * @throws java.sql.SQLException
     * @throws org.apache.commons.cli.ParseException
     */
    public static void main(String[] args) throws SQLException, ParseException {

        String propertiesFile = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.localdb.database.connection.file", "statusPersister.properties");
        Properties p = BootstrapResourceUtils.getBootstrapProperties(propertiesFile);

        String[] connSplit = p.getProperty("hibernate.connection.url", "").split("/");
        String schemaName = connSplit[connSplit.length - 1];

        try (Connection connection = DriverManager.getConnection(p.getProperty("hibernate.connection.url") + "?user=" + p.getProperty("hibernate.connection.username") + "&password=" + p.getProperty("hibernate.connection.password"))) {
            connection.setSchema(schemaName);
            PreparedStatement dropConstraint = connection.prepareStatement("alter table ccs_rawData drop foreign key ccs_rawDa_dataDeId_dataDe_fk;");
            dropConstraint.execute();
            System.out.println("done");
        }
    }

}

