package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class TrendingData implements Serializable {

    @XmlElement
    DataValue[] datavalue;
    @XmlElement
    AxisValue axisvalue;

    public static class DataValue {

        @XmlAttribute
        String name = "";
        @XmlAttribute
        double value;

        public DataValue(String name, double value) {
            this.name = name;
            this.value = value;
        }

        public DataValue() {
        }

        public double getValue() {
            return value;
        }

        public String getName() {
            return name;
        }
    }

    public static class AxisValue {

        @XmlAttribute
        String name = "";
        @XmlAttribute
        long value;
        @XmlAttribute
        long loweredge;
        @XmlAttribute
        long upperedge;

        public AxisValue(String name, long value) {
            this.name = name;
            this.value = value;
            this.loweredge = value;
            this.upperedge = value;
        }

        public AxisValue(String name, long value, long loweredge, long upperedge) {
            this.name = name;
            this.value = value;
            this.loweredge = loweredge;
            this.upperedge = upperedge;
        }

        public AxisValue() {
        }

        public long getLoweredge() {
            return loweredge;
        }

        public String getName() {
            return name;
        }

        public long getUpperedge() {
            return upperedge;
        }

        public long getValue() {
            return value;
        }
    }

    public void setAxisValue(AxisValue axisValue) {
        this.axisvalue = axisValue;
    }

    public void setDataValue(DataValue[] dataValue) {
        this.datavalue = dataValue;
    }

    public DataValue[] getDatavalue() {
        return datavalue;
    }

    public AxisValue getAxisvalue() {
        return axisvalue;
    }
    
    public double getValue(String name) {
        if ( datavalue != null ) {
            for (int i = 0; i < datavalue.length; i++) {
                if (datavalue[i].getName().equals(name)) {
                    return datavalue[i].getValue();
                }
            }
        }
        return Double.NaN;
    }
    
}
