package org.lsst.ccs.localdb.utils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
/**
 * A Class to issue requests against the REST server.
 * 
 * @author The LSST CCS Team
 */
public class TrendingConnectionUtils {

    private final Client client = ClientBuilder.newClient();
    private final String baseUrl;
    private final WebTarget serv;
    private static final Logger LOG = Logger.getLogger(TrendingConnectionUtils.class.getName());
    
    public TrendingConnectionUtils(String serverName, int serverPort) {
        this(serverName,serverPort,"/rest/data");
    }
    
    public TrendingConnectionUtils(String serverName, int serverPort, String entryPoint) {
        baseUrl = String.format("http://%s:%d%s", serverName, serverPort,entryPoint);        
        serv = client.target(baseUrl).path("dataserver");        
    }
    
    public DataChannel.DataChannelList getChannelList() {
        return serv.path("listchannels").request(MediaType.TEXT_XML).get(DataChannel.DataChannelList.class);
    }

    public TrendingData getLatestData(String path) {
        TrendingData res = null;
        try {
            res = serv.path("data/latest").queryParam("path", path).request(MediaType.TEXT_XML).get(TrendingData.class);
        } catch (Exception e) {
            //We got an exception; this could be due to either a server error or to the 
            //fact that the requested path does not exist
            DataChannel.DataChannelList availableChannels = getChannelList();
            boolean channelExists = false;
            String fullPath = "/"+path;
            for ( DataChannel channel : availableChannels.list  ) {
                if ( channel.getPathAsString().equals(fullPath) ) {
                    channelExists = true;
                    break;
                }
            }
            if ( channelExists ) {
                LOG.log(Level.WARNING,"Exception while fetching latest data for path: "+path,e);
            } else {
                res = new TrendingData();
                long tStamp = System.currentTimeMillis();
                TrendingData.AxisValue axisValue = new TrendingData.AxisValue("time", tStamp);
                res.setAxisValue(axisValue);
                TrendingData.DataValue[] dataValue = new TrendingData.DataValue[1];
                Double dd = 0.0;
                dataValue[0] = new TrendingData.DataValue("value", dd);
                res.setDataValue(dataValue);
            }
        }
        return res;
    }

    public String getBaseUrl() {
        return baseUrl;
    }
    
}
