package org.lsst.ccs.localdb.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * Migration utility for AgentState entities.
 * It empties the AgentState#getInnerStates manyToMany association, and replaces it
 * by an entry in the map componentStates map, with the empty String as key.
 * 
 * @author LSST CCS Team
 */
public class CreateSequenceTable {
    
    private static final Logger log = Logger.getLogger("org.lsst.ccs.localdb");
    
    public static void main(String[] args) throws SQLException {
    
        Properties p = BootstrapResourceUtils.getBootstrapProperties("statusPersister");
        
        String[] connSplit = p.getProperty("hibernate.connection.url", "").split("/");
        String schemaName = connSplit[connSplit.length - 1];
        
        try (Connection connection = DriverManager.getConnection(p.getProperty("hibernate.connection.url") + "?user=" + p.getProperty("hibernate.connection.username") + "&password=" + p.getProperty("hibernate.connection.password"))) {
            connection.setSchema(schemaName);
            // Create the ccs_enhanced_sequence table if it is not there yet.
            PreparedStatement ps = connection.prepareStatement("show tables like 'ccs_enhanced_sequence'");
            ResultSet rs = ps.executeQuery();
            if(!rs.next()) {
                log.info("creating ccs_enhanced_sequence table");
                // The ccs_enhanced_sequence table is not there
                connection.prepareStatement("CREATE TABLE `ccs_enhanced_sequence` (`next_val` bigint(20) DEFAULT NULL)").execute();
                connection.prepareStatement("insert into ccs_enhanced_sequence(next_val)  values((select max(id)+1 from ccs_statTimeInterval))").execute();
            }
            System.out.println("done");
        }
    }
    
    
}
