package org.lsst.ccs.localdb.statusdb.trendServer;

import org.lsst.ccs.localdb.statusdb.server.DataServer;
import org.lsst.ccs.localdb.statusdb.server.DebugExceptionMapper;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import org.lsst.ccs.messaging.NetworkUtilities;

/**
 * Class responsible for creating and starting the rest server.
 * @author LSST CCS Team
 */
public class RestServer {
    
    private HttpServer s;
    private static int port = 8080;
    private static String host = null;
    
    private final String restRoot = "/rest/data";

    RestServer() {
    }
    
    public RestServer(int port) {
        this.port = port;
    }
    
    public void start() {
        class MyApplication extends Application {
            
            @Override
            public Set<Class<?>> getClasses() {
                Set<Class<?>> s = new HashSet<Class<?>>();
                s.add(DataServer.class);
                s.add(DebugExceptionMapper.class);
                return s;
            }
        }
        
        MyApplication app = new MyApplication();
        HttpHandler h = RuntimeDelegate.getInstance().createEndpoint(app, HttpHandler.class);
        try {
            s = HttpServer.create(new InetSocketAddress(port), 5);
        } catch (IOException ex) {
            throw new RuntimeException("could not create http server", ex);
        }
        s.createContext(restRoot, h);
        s.start();        
    }

    public void stop() {
        //Give it a second to close the HttpServer        
        s.stop(1);
    }
    
    public static int getRestServerPort() {
        return port;
    }
    
    public static String getRestServerHost() {        
        if (host == null) {
            try {
                NetworkInterface ne = NetworkInterface.getByName(NetworkUtilities.getMainInterfaceName());
                for ( InterfaceAddress ia : ne.getInterfaceAddresses() ) {
                    boolean isIPV6 = ia.getAddress() instanceof Inet6Address;
                    if  ( isIPV6 ) {
                        continue;
                    }
                    host = ia.getAddress().getHostAddress();
                    break;
                }
            } catch (SocketException e) {
            }
        }
        return host;
    }  
    
    public static void main(String[] args) {
        System.out.println(RestServer.getRestServerHost());
    }
}
