package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.NaturalId;

/**
 * A time interval for statistical data. All it has is a start and end time to define the
 * interval. The times are in Epoch milliseconds.
 * 
 */
@Entity
@Table(
        indexes = {@Index(columnList = "binWidth,startTime"),@Index(columnList = "endTime")},
        uniqueConstraints = @UniqueConstraint(columnNames = {"startTime","binWidth"})
)
@Cacheable
@Immutable
@org.hibernate.annotations.Cache( 
        usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_ONLY
        ,region = "org.lsst.ccs.localdb.statusdb.model.StatTimeInterval"
)
@org.hibernate.annotations.NaturalIdCache
@NamedQueries ( {
    @NamedQuery (
            name = "findStatTimeInterval",
            query = "from StatTimeInterval sti where sti.startTime=:st and sti.binWidth=:bw",
            hints = {@QueryHint(name="org.hibernate.cacheable", value="true")}
    )
})

public class StatTimeInterval implements Serializable {
    
    private static final long serialVersionUID = 7128231906408578843L;

    private long id;
    private long startTime;
    private long binWidth;
    private long endTime;

    public StatTimeInterval() {
    }

    public StatTimeInterval(long startTime, long binWidth) {
        this.startTime = startTime;
        this.binWidth = binWidth;
        this.endTime = startTime+binWidth;
    }

    /**
     * @return the id
     */
    @Id
    // The id must be set on the application side for natural id cache to work
    @GeneratedValue(generator = "ID_SEQUENCE_GENERATOR")
    public long getId() {
        return id;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(long id) {
        this.id = id;
    }


    /**
     * @return the startTime
     */
    @NaturalId(mutable = false)
    public long getStartTime() {
        return startTime;
    }

    /**
     * @param startTime
     *            the startTime to set
     */
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    /**
     * @param endTime
     *            the startTime to set
     */
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    /**
     * @return the endTime
     */
    public long getEndTime() {
        return endTime;
    }

    @NaturalId(mutable = false)
    public long getBinWidth() {
        return binWidth;
    }
    
    public void setBinWidth(long binWidth) {
        this.binWidth = binWidth;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (int) (getStartTime() ^ (getStartTime() >>> 32));
        hash = 47 * hash + (int) (getBinWidth() ^ (getBinWidth() >>> 32));
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatTimeInterval)){
            return false;
        }
        final StatTimeInterval other = (StatTimeInterval) obj;
        return getStartTime() == other.getStartTime() && getBinWidth() == other.getBinWidth();
    }

}
