package org.lsst.ccs.localdb.utils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
/**
 * A Class to issue requests against the REST server.
 * 
 * @author The LSST CCS Team
 */
public class TrendingConnectionUtils {

    private final Client client = ClientBuilder.newClient();
    private final String baseUrl;
    private final WebTarget serv;
    private static final Logger LOG = Logger.getLogger(TrendingConnectionUtils.class.getName());
    
    public TrendingConnectionUtils(String serverName, int serverPort) {
        this(serverName,serverPort,"/rest/data");
    }
    
    public TrendingConnectionUtils(String serverName, int serverPort, String entryPoint) {
        baseUrl = String.format("http://%s:%d%s", serverName, serverPort,entryPoint);        
        serv = client.target(baseUrl).path("dataserver");        
    }
    
    public DataChannel.DataChannelList getChannelList() {
        return serv.path("listchannels").request(MediaType.TEXT_XML).get(DataChannel.DataChannelList.class);
    }

    public TrendingData getLatestData(String path) {
        TrendingData res = null;
        try {
            res = serv.path("data/latest").queryParam("path", path).request(MediaType.TEXT_XML).get(TrendingData.class);
        } catch (Exception e) {
            LOG.log(Level.WARNING,"Exception while fetching latest data for path: "+path,e);
        }
        return res;
    }

    public String getBaseUrl() {
        return baseUrl;
    }
    
}
