package org.lsst.ccs.localdb.statusdb.server;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.lsst.ccs.localdb.statusdb.trendServer.RestServer;

/**
 * A state description.
 * @author LSST CCS Team
 */
@XmlRootElement(name = "stateinfo")
public class StateInfo {
    
    private String stateClass;
    
    private final Set<String> stateValues = new HashSet<>();
    
    public StateInfo() {
        
    }
    
    public StateInfo(String stateClass) {
        this.stateClass = stateClass;
    }
    
    /**
     * @return the state class name.
     */
    @XmlElement(name = "statename")
    public String getStateClass() {
        return stateClass;
    }
    
    /**
     * 
     * @return The possible state values.
     */
    @XmlElement(name = "value")
    @XmlElementWrapper(name = "statevalues")
    public Set<String> getStateValues() {
        return stateValues;
    }
    
    @XmlRootElement(name="stateinfos")
    public static class StateInfoList {
        
        @XmlElement(name="stateinfo")
        public List<StateInfo> stateInfoList;
        
        public StateInfoList() {
            
        }
        
        public StateInfoList(List<StateInfo> l ) {
            this.stateInfoList = l;
        }
        
    }    
    
	// wrapper class to get the correct collection name
	
	@XmlRootElement(name="datachannels")
	public static class StateChannelList {

            @XmlElement(name = "datachannel")
            public List<Channel> list;

            @XmlAttribute
            private Date activeSinceDate;

            @XmlAttribute
            private String host;

            @XmlAttribute
            private int port;

            public StateChannelList(List<Channel> list, long milliseconds) {
                this.list = list;
                activeSinceDate = new Date(milliseconds);
                this.host = RestServer.getRestServerHost();
                this.port = RestServer.getRestServerPort();
            }

            public StateChannelList() {
            }

            public Date getActiveSinceDate() {
                return activeSinceDate;
            }
            
            public int getPort() {
                return port;
            }
            
            public String getHost() {
                return host;
            }
            
	}
}
