package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.lsst.ccs.localdb.statusdb.model.DataPath;

/**
 * Just base class for a Channel
 * 
 * @author The LSST CCS Team
 */
@XmlRootElement(name = "datachannel")
public class Channel implements Serializable {
    
    /**
     * Channel's path For example : subsystem/variable (FCS/carouselPosition)
     *
     */
    @XmlElement(name = "pathelement")
    @XmlElementWrapper
    protected String[] path; // TODO decide how to construct that path, could be
    // :
    // DataDesc.scrSubsystem, DataDesc.srcName

    Map<String, String> metadata = new HashMap<>();
    
    
    Channel() {};

    final public String[] getPath() {
        return path;
    }

    final public String getPathAsString() {
        return DataPath.encodePath(getPath());
    }
    
    @XmlElement(name = "metadata")
    List<HashMapEntry4XML> getMetadataList() {
        return HashMapEntry4XML.marshal(metadata);
    }
    
    public Map<String, String> getMetadata() {
        return metadata;
    }

}
