package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;

/**
 * Persistence of states the class definition of which is unknown to the framework.
 * @author LSST CCS Team
 */
@Entity
@Table(uniqueConstraints = @UniqueConstraint(columnNames = {"enumClassName", "enumValue"}))
@Immutable
@Cacheable
@org.hibernate.annotations.Cache( 
        usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_ONLY
        ,region = "org.lsst.ccs.localdb.statusdb.model.InnerStateDesc"
)
@NamedQueries ( {
    @NamedQuery (
            name = "findInnerStateDesc",
            query = "from InnerStateDesc isd where "
                    + "isd.enumClassName=:enumClassName and isd.enumValue=:enumValue",
            hints = {@QueryHint(name="org.hibernate.cacheable", value="true")}
    )
})
public class InnerStateDesc implements Serializable {
    
    private static final long serialVersionUID = 8013380216518833656L;
    
    private long id;
    
    private String enumClassName;
    
    private String enumValue;

    public InnerStateDesc() {
        
    }
    
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }
    
    @Column(nullable = false)
    public String getEnumClassName() {
        return enumClassName;
    }
    
    @Transient
    public String getEnumSimpleClassName() {
        int ind = enumClassName.lastIndexOf(".");
        if ( ind < 0 ) {
            return enumClassName;
        } 
        return enumClassName.substring(ind+1);
    }

    public void setEnumClassName(String enumClassName) {
        this.enumClassName = enumClassName;
    }

    @Column(nullable = false)
    public String getEnumValue() {
        return enumValue;
    }

    public void setEnumValue(String enumValue) {
        this.enumValue = enumValue;
    }
    
    @Override
    public String toString() {
        return enumClassName+":"+enumValue;
    }
    
}
