package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;

/**
 * An object describing a statistical data bin.
 * For each DataDesc (i.e. data path) there is a StatDesc object for each bin width
 * supported. This object is then reused for multiple time intervals.
 */
@Entity
//@DynamicUpdate(true)
//@DynamicInsert(true)
@Table(uniqueConstraints = @UniqueConstraint(columnNames = {"dataDescId","timeBinWidth"}),
        indexes = {@Index(columnList = "dataDescId")}
)
@Immutable
@Cacheable
@org.hibernate.annotations.Cache( 
        usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_ONLY
        ,region = "org.lsst.ccs.localdb.statusdb.model.StatDesc"
)
@NamedQueries ( {
    @NamedQuery (
            name = "findStatDesc",
            query = "from StatDesc s where s.dataDesc=:dd",
            hints = {@QueryHint(name="org.hibernate.cacheable", value="true")}
    ),
    @NamedQuery (
            name = "findStatDescById",
            query = "from StatDesc sd where sd.dataDesc.id=:id",
            hints = {@QueryHint(name="org.hibernate.cacheable", value="true")}
    )
})
public class StatDesc implements Serializable {
    private static final long serialVersionUID = -4640537966560757206L;

    private long id;
    private DataDesc dataDesc;
    private long timeBinWidth;

    /**
     * @return the id
     */
    @Id()
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    public long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * @return the dataDesc
     */
    @ManyToOne(optional = false/*, cascade = CascadeType.MERGE*/, fetch = FetchType.LAZY)
    @JoinColumn(name = "dataDescId", updatable = false)
    public DataDesc getDataDesc() {
        return dataDesc;
    }

    /**
     * @param dataDesc the dataDesc to set
     */
    public void setDataDesc(DataDesc dataDesc) {
        this.dataDesc = dataDesc;
    }

    /**
     * @return the timeBinWidth
     */
    public long getTimeBinWidth() {
        return timeBinWidth;
    }

    /**
     * @param timeBinWidth the timeBinWidth to set
     */
    public void setTimeBinWidth(long timeBinWidth) {
        this.timeBinWidth = timeBinWidth;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(getDataDesc());
        hash = 59 * hash + (int) (this.getTimeBinWidth() ^ (getTimeBinWidth() >>> 32));
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatDesc)) {
            return false;
        }
        final StatDesc other = (StatDesc) obj;
        if(!getDataDesc().equals(other.getDataDesc())) {
            return false;
        }
        if(!(getTimeBinWidth() == other.getTimeBinWidth())) {
            return false;
        }
        return true;
    }
    
    
    
}
