package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

/**
 * Groups {@code DataDesc} entities under a groupName.
 * @author LSST CCS Team
 */
@Entity
@Table(uniqueConstraints = @UniqueConstraint(columnNames = {"agentName","groupName"}))
@Cacheable
@org.hibernate.annotations.Cache(
        usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_WRITE
        ,region = "org.lsst.ccs.localdb.statusdb.model.DataGroup"
)
@NamedQueries ( {
    @NamedQuery (
            name = "findDataGroup",
            query = "from DataGroup dg where dg.agentName=:agentName and dg.groupName=:groupName",
            hints = {@QueryHint(name="org.hibernate.cacheable", value="true")}
    )
})
public class DataGroup implements Serializable {
    private static final long serialVersionUID = -963831608204511397L;
    
    private long id;
    
    private String agentName;
    
    private String groupName;
    
    private Map<DataPath, DataDesc> members = new HashMap<>();
            
    public DataGroup() {
        
    }
    
    public DataGroup(String agentName, String groupName) {
        this.agentName = agentName;
        this.groupName = groupName;
    }
    
    /**
     * @return the id
     */
    @Id()
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    public long getId() {
        return id;
    }
    
    public String getAgentName() {
        return agentName;
    }
    
    public String getGroupName() {
        return groupName;
    }
    
    @ManyToMany(fetch = FetchType.LAZY)
    @MapKey(name = "dataPath")
    public Map<DataPath, DataDesc> getMembers() {
        return members;
    }
    
    /**
     * @param id the id to set
     */
    public void setId(long id) {
        this.id = id;
    }
    
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setMembers(Map<DataPath,DataDesc> members) {
        this.members = members;
    }
    
    public void addMember(DataDesc dd) {
        members.put(dd.getDataPath(), dd);
    }
}
