/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.dao;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.model.AgentState;
import org.lsst.ccs.localdb.statusdb.model.AlertDesc;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.model.StatTimeInterval;
import org.lsst.ccs.localdb.statusdb.model.StateBundleDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class LocaldbFacade {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.statusdb");

    private LocaldbFacade() {
    }

    public static AgentDesc getAgentDesc(AgentInfo agentInfo, Session sess) {
        String key = agentInfo.getName();
        AgentDesc ad = (AgentDesc)sess.get(AgentDesc.class, (Serializable)((Object)key));
        if (ad == null) {
            ad = new AgentDesc(agentInfo);
            sess.persist((Object)ad);
            log.debug((Object)("Added Agent description for " + key + " : " + ad.getAgentName()));
        }
        return ad;
    }

    public static AlertDesc getAlertDescOrPersist(AgentDesc agentDesc, Alert alert, Session sess) {
        AlertDesc ad = LocaldbFacade.getAlertDesc(agentDesc, alert.getAlertId(), sess);
        if (ad == null) {
            ad = new AlertDesc();
            ad.setAgentDesc(agentDesc);
            ad.setAlertId(alert.getAlertId());
            ad.setAlertDescription(alert.getDescription());
            sess.persist((Object)ad);
            log.debug((Object)("Added Alert description for " + agentDesc.getAgentName() + "/" + alert.getAlertId() + " : " + ad.getAlertId()));
        }
        return ad;
    }

    public static AlertDesc getAlertDesc(AgentDesc agentDesc, String alertId, Session sess) {
        Query q = sess.getNamedQuery("findAlertDesc");
        q.setString("id", alertId).setString("name", agentDesc.getAgentName());
        return (AlertDesc)q.uniqueResult();
    }

    private static InnerStateDesc getInnerStateDesc(String enumClassName, String enumValue, Session sess) {
        Query q = sess.getNamedQuery("findInnerStateDesc");
        q.setString("enumClassName", enumClassName).setString("enumValue", enumValue);
        InnerStateDesc isd = (InnerStateDesc)q.uniqueResult();
        if (isd == null) {
            isd = new InnerStateDesc();
            isd.setEnumClassName(enumClassName);
            isd.setEnumValue(enumValue);
            sess.persist((Object)isd);
            log.debug((Object)("Added Inner State description description for " + isd.toString()));
        }
        return isd;
    }

    private static StateBundleDesc getStateBundleDesc(Map<String, String> states, Session sess) {
        HashMap<String, InnerStateDesc> componentStates = new HashMap<String, InnerStateDesc>();
        for (Map.Entry<String, String> state : states.entrySet()) {
            componentStates.put(state.getKey(), LocaldbFacade.getInnerStateDesc(state.getKey(), state.getValue(), sess));
        }
        byte[] md5 = StateBundleDesc.computeMD5(componentStates);
        Query q = sess.getNamedQuery("findStateBundleDesc").setBinary("md5", md5);
        StateBundleDesc sbd = (StateBundleDesc)q.uniqueResult();
        if (sbd == null) {
            sbd = new StateBundleDesc();
            sbd.setComponentStates(componentStates);
            sbd.setHashMD5(md5);
            sess.persist((Object)sbd);
        }
        return sbd;
    }

    public static AgentState getAgentState(AgentDesc ad, StateBundle sb, Session sess) {
        AgentState as = null;
        HashMap<String, StateBundleDesc> compStates = new HashMap<String, StateBundleDesc>();
        HashMap<String, String> topStates = new HashMap<String, String>(sb.getAllStatesAsStrings());
        compStates.put("", LocaldbFacade.getStateBundleDesc(topStates, sess));
        for (String comp : sb.getComponentsWithStates()) {
            compStates.put(comp, LocaldbFacade.getStateBundleDesc(sb.getComponentStateBundle(comp).getAllStatesAsStrings(), sess));
        }
        byte[] md5 = AgentState.computeMD5(ad.getAgentName(), compStates);
        as = (AgentState)sess.byNaturalId(AgentState.class).using("agentDesc", (Object)ad).using("hashMD5", (Object)md5).load();
        if (as == null) {
            as = new AgentState(ad);
            as.setComponentStates(compStates);
            as.setHashMD5(md5);
            sess.persist((Object)as);
            log.debug((Object)("Added AgentState for " + as.toString()));
        }
        return as;
    }

    public static synchronized StatTimeInterval getStatTimeInterval(long binWidth, long dataTime) {
        long statTimeIntervalStart = dataTime / binWidth * binWidth;
        Session s = StatusdbUtils.getSessionForTimeIntervals();
        StatTimeInterval statTimeInterval = (StatTimeInterval)s.getNamedQuery("findStatTimeInterval").setLong("st", statTimeIntervalStart).setLong("bw", binWidth).setCacheable(true).uniqueResult();
        if (statTimeInterval == null) {
            Transaction tx = s.beginTransaction();
            statTimeInterval = new StatTimeInterval(statTimeIntervalStart, binWidth);
            s.persist((Object)statTimeInterval);
            tx.commit();
            s.close();
        }
        return statTimeInterval;
    }

    public static StatData getStatDataOrNull(StatDesc sd, StatTimeInterval sti, Session sess) {
        return (StatData)sess.getNamedQuery("findStatData").setEntity("d", (Object)sd).setEntity("sti", (Object)sti).setCacheable(true).uniqueResult();
    }
}

