package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;


/**
 * Defines a subsystem for which there are trending channels associated.
 */
@XmlRootElement(name = "subsystem")
public class DataSubsystem implements Serializable {

	private static final long serialVersionUID = -9154127909107314678L;

	public DataSubsystem(String name) {
            this.subsystemName = name;
	}

	public DataSubsystem() {
	}

	protected String subsystemName;
	
	@XmlElement()
	public String getSubsystemName() {
            return subsystemName;
	}
	
	public void setSubsystemName(String subsystemName) {
		this.subsystemName = subsystemName;
	}
	
	// wrapper class to get the correct collection name
	
	@XmlRootElement(name="subsystems")
	public static class DataSubsystemList {
		@XmlElement(name="subsystem")
		public List<DataSubsystem> list;

		public DataSubsystemList(List<DataSubsystem> list) {
			this.list = list;
		}
		
		public DataSubsystemList() {}
	}

}
