package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import javax.persistence.ConstraintMode;

import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(indexes = { @Index(columnList = "time"),
        /* @Index(columnList = "dataDescId"), */ @Index(columnList = "dataDescId,time") })
@IdClass(RawDataId.class)
public class RawData implements Serializable {

    private static final long serialVersionUID = 5996448023570084719L;
    private long id; // do we need this? Perhaps for filter, or whatever
    private DataDesc dataDesc;
    private long time;
    private Double doubleData;
    private String stringData;

    /**
     * @return the id
     */
    @Id
    @GeneratedValue(generator = "ID_INCREMENTAL_GENERATOR")
    public long getId() {
        return id;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * @return the dataDesc
     */
    @ManyToOne(optional = false)
    @JoinColumn(foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public DataDesc getDataDesc() {
        return dataDesc;
    }

    /**
     * @param dataDesc
     *            the dataDesc to set
     */
    public void setDataDesc(DataDesc dataDesc) {
        this.dataDesc = dataDesc;
    }

    /**
     * @return the time
     */
    @Id
    public long getTime() {
        return time;
    }

    /**
     * @param time
     *            the time to set
     */
    public void setTime(long time) {
        this.time = time;
    }

    /**
     * @return the doubleData
     */
    public Double getDoubleData() {
        return doubleData;
    }

    /**
     * @param doubleData
     *            the doubleData to set
     */
    public void setDoubleData(Double doubleData) {
        this.doubleData = doubleData;
    }

    /**
     * @return the stringData
     */
    public String getStringData() {
        return stringData;
    }

    /**
     * @param stringData
     *            the stringData to set
     */
    public void setStringData(String stringData) {
        this.stringData = stringData;
    }
    // public Integer intData; ??
    // can be a keyword - example : temperature to retrieve all temperature data
    // for one subsystem ?

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("RawData: ");
        sb.append(dataDesc).append(" ");
        sb.append(getDoubleData());
        return sb.toString();
    }    
}
// TODO description of derived data to be computed, and statistical data output,
// two tables.
