/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.localdb.statusdb.utils;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;

import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.localdb.statusdb.model.CCSNamingStrategy;
import java.util.logging.Logger;

/**
 *
 * @author turri
 */
public class StatusdbUtils {

    private static Configuration cfg;
    private static SessionFactory fac;

    private static final Logger LOG = Logger.getLogger(StatusdbUtils.class.getName());
    
    private StatusdbUtils() {
    }

    public static boolean isInitialized() {
        return fac != null;
    }
    
    public static synchronized SessionFactory getSessionFactory() {
        return getSessionFactory(null);
    }
    public static synchronized SessionFactory getSessionFactory(Properties inputProperties) {
        if (cfg == null) {

            String hibernateConfigFile = System.getProperty("org.lsst.ccs.localdb.hibernate.config.file", "hibernate-tm.cfg.xml");
            String propertiesFile = System.getProperty("org.lsst.ccs.localdb.hibernate.properties.file", "statusPersister.properties");

            try {
                URL configFileFullURL = BootstrapResourceUtils.getResourceURL(hibernateConfigFile);
                LOG.log(Level.INFO, "hibernate config from {0}", configFileFullURL);
                cfg = new Configuration().configure(configFileFullURL);
            } catch (MalformedURLException ex) {
                LOG.log(Level.SEVERE, "Problem loading hibernate configuration file "+hibernateConfigFile, ex);
                throw new RuntimeException("Could not configur Hibernate", ex);
            }
            
            // Defining the naming strategy (does not work when set in the configuration
            cfg.setImplicitNamingStrategy(new CCSNamingStrategy());
            
//            Properties cfgProps = FrameworkUtils.loadProperties(null, StatusdbUtils.class, propertiesFile);
            //Load the properties from the environment.
            //The Properties must be flat as the addProperties method on the Configuration object
            //does not support chained properties.
            Properties cfgProps = new Properties();
            try {
                cfgProps.load(BootstrapResourceUtils.getBootstrapPropertiesInputStream(propertiesFile, StatusdbUtils.class));            
                LOG.log(Level.INFO, "hibernate properties from {0}:\n {1}", new Object[]{propertiesFile,cfgProps});
            } catch (IOException ioe) {
            }

            if (inputProperties != null) {
                cfgProps.putAll(inputProperties);
            }

            LOG.log(Level.INFO, "hibernate configuration:\n {0}", cfgProps);
            cfg = cfg.addProperties(cfgProps);
            
            Properties finalP = cfg.getProperties();
            LOG.log(Level.FINER,"*** Working with connection properties ");
            for (Object key : finalP.keySet()) {
                String skey = (String) key;
                if (skey.startsWith("hibernate")) {
                    LOG.log(Level.FINER, "{0}: {1}", new Object[]{skey, finalP.getProperty(skey)});
                }
            }
            LOG.log(Level.FINER,"*********************************");
        }

        if (fac == null) {
            fac = cfg.buildSessionFactory();
        }

        return fac;
    }
    
    public static synchronized void closeSessionFactory() {
        if (fac != null) {
            fac.close();
        }
        fac = null;
        cfg = null;

    }
    
}
