package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

@Entity
@DynamicUpdate(true)
@DynamicInsert(true)
@Table(indexes = { @Index(columnList = "dataDescId"), @Index(columnList = "startTime"), @Index(columnList = "endTime"),
        @Index(columnList = "dataDescId, startTime, endTime") })
public class MetaDataData implements Serializable {

    private static final long serialVersionUID = -4865726722836287292L;

    private DataGroup dataGroup;

    private long startTime, endTime = -1;
    private String name, value;
    private long id;

    protected MetaDataData() {

    }

    public MetaDataData(long startTime) {
        this.startTime = startTime;
    }

    /**
     * @return the id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    public long getId() {
        return id;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * @param name
     *            the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return the value
     */
    public String getValue() {
        return value;
    }

    /**
     * @param value
     *            the value to set
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * @return the dataDesc
     */
    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "dataDescId")
    public DataGroup getDataGroup() {
        return dataGroup;
    }

    /**
     * @param dataGroup
     *            the dataGroup
     */
    public void setDataGroup(DataGroup dataGroup) {
        this.dataGroup = dataGroup;
    }

    /**
     * @return the startTime
     */
    public long getStartTime() {
        return startTime;
    }

    /**
     * @param startTime
     *            the startTime to set
     */
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    /**
     * @return the endTime
     */
    public long getEndTime() {
        return endTime;
    }

    /**
     * @param endTime
     *            the endTime to set
     */
    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }
}
