package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

/**
 * A timed change of a ConfigurationParameter.
 * 
 * @author LSST CCS Team
 */

@Entity
@Table(uniqueConstraints = {
    @UniqueConstraint(columnNames = {"configurationParameterId", "value", "tChanged"})})
@Cacheable
@org.hibernate.annotations.Cache(
        usage = org.hibernate.annotations.CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, 
        region = "org.lsst.ccs.localdb.configdb.model.ConfigurationParameterValue"
)
public class ConfigurationParameterValue  implements Serializable, PathObject {
    
    private static final long serialVersionUID = 774337848554181101L;
    
    private long id;
    
    private ConfigurationParameter configurationParameter ;

    /** The value assigned to the configuration parameter. */
    private String value ;
    
    private long tChanged;
    
    ///////////////////////// CONSTRUCTORS

    protected ConfigurationParameterValue() {

    }
    
    /**
     * create an empty parameter configuration whose value is to be modified
     * @param configurationParameter
     * @param value
     * @param tChanged
     */
    public ConfigurationParameterValue(ConfigurationParameter configurationParameter, String value, long tChanged) {
        this.configurationParameter = configurationParameter;
        this.value = value;
        this.tChanged = tChanged;
    }

    /**
     * @return the configured value for this parameter
     */
    public String getValue() {
        return value;
    }

    void setValue(String value) {
        this.value = value;
    }

    ///////////////////////////// IDENT METHODS

    @Override
    @Transient
    public ParameterPath getPath() {
        return configurationParameter.getPath();
    }
    
    @Id
    @GeneratedValue(generator = "ID_SEQUENCE_GENERATOR")
    public long getId() {
        return id;
    }

    protected void setId(long id) {
        this.id = id ;
    }

    public long getTChanged() {
        return tChanged;
    }

    public void setTChanged(long tchanged) {
        this.tChanged = tchanged;
    }

    @ManyToOne (fetch=FetchType.EAGER, optional = false)
    ConfigurationParameter getConfigurationParameter() {
        return configurationParameter;
    }

    void setConfigurationParameter(ConfigurationParameter parameterDescription) {
        this.configurationParameter = parameterDescription;
    }

    @Override
    public String toString() {
        return  this.getId() + "{" + getId() +
                ": description=" + configurationParameter +
                ", value='" + value + '\'' +
                '}';
    }
    
}
