/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.localdb.statusdb.utils;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.localdb.statusdb.model.CCSNamingStrategy;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author turri
 */
public class StatusdbUtils {

    private static Configuration cfg;
    private static SessionFactory fac;

    protected static Logger log = Logger.getLogger("org.lsst.ccs.localdb");
    
    private StatusdbUtils() {
    }

    public static synchronized SessionFactory getSessionFactory(Properties inputProperties) {
        if (cfg == null) {

            String hibernateConfigFile = System.getProperty("org.lsst.ccs.localdb.hibernate.config.file", "hibernate-tm.cfg.xml");
            String propertiesFile = System.getProperty("org.lsst.ccs.localdb.hibernate.properties.file", "statusPersister.properties");

            try {
                URL configFileFullURL = BootstrapResourceUtils.getResourceURL(hibernateConfigFile);
                log.info("hibernate config from " + configFileFullURL);
                cfg = new Configuration().configure(configFileFullURL);
            } catch (MalformedURLException ex) {
                log.severe(ex);
                throw new RuntimeException("Could not configur Hibernate", ex);
            }
            log.info("hibernate properties from " + propertiesFile);
            
            // Defining the naming strategy (does not work when set in the configuration
            cfg.setImplicitNamingStrategy(new CCSNamingStrategy());
            
//            Properties cfgProps = FrameworkUtils.loadProperties(null, StatusdbUtils.class, propertiesFile);
            //Load the properties from the environment.
            //The Properties must be flat as the addProperties method on the Configuration object
            //does not support chained properties.
            Properties cfgProps = new Properties();
            try {
                cfgProps.load(BootstrapResourceUtils.getBootstrapPropertiesInputStream(propertiesFile, StatusdbUtils.class));
            } catch (IOException ioe) {
                throw new RuntimeException("Could not load Hibernate properties", ioe);
            }

            cfg = cfg.addProperties(cfgProps);

            if (inputProperties != null) {
                log.info("adding input properties");
                cfg = cfg.addProperties(inputProperties);
            }

            Logger log = Logger.getLogger("org.lsst.ccs.localdb");
            Properties finalP = cfg.getProperties();
            log.debug("*** Working with connection properties ");
            for (Object key : finalP.keySet()) {
                String skey = (String) key;
                if (skey.startsWith("hibernate")) {
                    log.debug(skey + ": " + finalP.getProperty(skey));
                }
            }
            log.debug("*********************************");
        }

        if (fac == null) {
            fac = cfg.buildSessionFactory();
        }

        return fac;
    }
    
    public static synchronized void closeSessionFactory() {
        if (fac != null) {
            fac.close();
        }
        fac = null;
        cfg = null;

    }
    
}
