/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.localdb.configdb.model.BaseDescription;
import org.lsst.ccs.localdb.configdb.model.Configuration;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameter;
import org.lsst.ccs.localdb.configdb.model.ConfigurationRun;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.GlobalConfiguration;
import org.lsst.ccs.localdb.configdb.model.HibernateDAO;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigHibernateTest
extends LocaldbTestTemplate {
    private static HibernateDAO dbInterface;

    @BeforeClass
    public static void setupClass() throws Exception {
        System.setProperty("hsqldb.reconfig_logging", "true");
        System.setProperty("org.jboss.logging.provider", "jdk");
        Logger.getLogger("hsqldb.db").setLevel(Level.OFF);
        Logger.getLogger("org.hibernate").setLevel(Level.OFF);
        Logger.getLogger("org.jboss").setLevel(Level.OFF);
        p.setProperty("hibernate.use_sql_comments", "false");
        p.setProperty("hibernate.show_sql", "false");
        p.setProperty("hibernate.format_sql", "false");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        dbInterface = new HibernateDAO(sessionFactory);
    }

    @Before
    public void init() {
    }

    @After
    public void cleanupDB() {
        this.clearDatabase();
    }

    @Test
    public void testScenarios() throws Exception {
        dbInterface.begin();
        AgentDesc ad = new AgentDesc(new AgentInfo("someName", AgentInfo.AgentType.WORKER));
        dbInterface.persist((Object)ad);
        ConfigurationInfo.Builder cib = new ConfigurationInfo.Builder();
        ConfigurationInfo ci = cib.addParameter(ParameterPath.valueOf((String)"main/info"), String.class, "catA", "", true, false).updateParameter(ParameterPath.valueOf((String)"main/info"), "info", "info", false).addParameter(ParameterPath.valueOf((String)"main/max"), Integer.TYPE, "catA", "", false, false).addParameter(ParameterPath.valueOf((String)"son/max"), Integer.TYPE, "catA", "", false, false).build();
        ArrayList<ConfigurationParameter> parmList = new ArrayList<ConfigurationParameter>();
        for (ConfigurationParameterInfo cpi : ci.getAllParameterInfo()) {
            parmList.add(dbInterface.createConfigurationParameter("someName", cpi.getComponentName(), cpi.getParameterName(), "", cpi.getActualType().getTypeName(), cpi.getCategoryName(), cpi.isFinal() ? cpi.getConfiguredValue() : null));
        }
        Description descA = dbInterface.getDescription(ad, parmList);
        BaseDescription bdescA = descA.getBaseDescription();
        long descAId = descA.getId();
        dbInterface.end();
        dbInterface.begin();
        long t0 = System.currentTimeMillis();
        Configuration config = dbInterface.getConfigurationOrCreate(bdescA, "configA1", "catA", -3, ci.getAllParameterInfo(), t0, null);
        Map parmValues = config.getConfigurationParameterValues();
        Assert.assertEquals((String)"size of defined values", (long)2L, (long)parmValues.keySet().size());
        Assert.assertTrue((boolean)parmValues.containsKey(org.lsst.ccs.localdb.configdb.model.ParameterPath.valueOf((String)"main/max")));
        Assert.assertTrue((boolean)parmValues.containsKey(org.lsst.ccs.localdb.configdb.model.ParameterPath.valueOf((String)"son/max")));
        ConfigurationRun run = new ConfigurationRun(descA, config, t0);
        dbInterface.populateRunFromScratch(run, Collections.emptyList());
        dbInterface.end();
        dbInterface.begin();
        run = dbInterface.getActiveConfigurationRun(descA, run.getConfiguration().getCategory());
        config = dbInterface.getConfigurationOrNull(bdescA, "configA1", "catA", 0);
        Assert.assertNotNull((Object)config);
        dbInterface.end();
        long t1 = t0 + 300L;
        cib.updateParameter(ParameterPath.valueOf((String)"main/max"), "0", "2000", true).addRecentChange("main/max");
        dbInterface.begin();
        config = dbInterface.getConfigurationOrNull(bdescA, "configA1", "catA", 0);
        run = dbInterface.getActiveConfigurationRun(descA, config.getCategory());
        ConfigurationRun nextRun = new ConfigurationRun(descA, config, t1);
        nextRun = dbInterface.populateRunFromPreviousRun(run, nextRun, cib.build().getLatestChanges());
        dbInterface.end();
        long t2 = t1 + 300L;
        cib.updateParameter(ParameterPath.valueOf((String)"son/max"), "0", "3000", true).addRecentChange("son/max");
        dbInterface.begin();
        nextRun = dbInterface.getActiveConfigurationRun(descA, "catA");
        config = dbInterface.getConfigurationOrNull(bdescA, "configA1", "catA", 0);
        ConfigurationRun nextRun2 = new ConfigurationRun(descA, config, t2);
        nextRun2 = dbInterface.populateRunFromPreviousRun(nextRun, nextRun2, cib.build().getLatestChanges());
        dbInterface.end();
        long t3 = t2 + 300L;
        dbInterface.begin();
        Configuration config2 = dbInterface.getConfigurationOrCreate(bdescA, "configA2", "catA", -3, cib.build().getAllParameterInfo(), t3, nextRun2);
        dbInterface.end();
        Assert.assertEquals((long)0L, (long)config2.getVersion());
        dbInterface.begin();
        config2 = dbInterface.getConfigurationOrNull(bdescA, "configA2", "catA", 0);
        nextRun2 = dbInterface.getActiveConfigurationRun(descA, "catA");
        ConfigurationRun nextRun3 = new ConfigurationRun(descA, config2, t3);
        nextRun3 = dbInterface.populateRunFromPreviousRun(nextRun2, nextRun3, Collections.emptyList());
        dbInterface.end();
        dbInterface.begin();
        long t4 = t3 + 300L;
        cib.updateParameter(ParameterPath.valueOf((String)"main/max"), "0", "4000", true).addRecentChange("main/max");
        config2 = dbInterface.getConfigurationOrNull(bdescA, "configA2", "catA", 0);
        nextRun3 = dbInterface.getActiveConfigurationRun(descA, "catA");
        ConfigurationRun nextRun4 = new ConfigurationRun(descA, config2, t4);
        nextRun4 = dbInterface.populateRunFromPreviousRun(nextRun3, nextRun4, cib.build().getLatestChanges());
        dbInterface.end();
        dbInterface.begin();
        long t5 = t4 + 300L;
        cib.updateParameter(ParameterPath.valueOf((String)"main/max"), "4000", "4000", false);
        Configuration config2bis = dbInterface.getConfigurationOrCreate(bdescA, "configA2", "catA", -3, cib.build().getAllParameterInfo(), t5, nextRun4);
        dbInterface.end();
        dbInterface.begin();
        config2bis = dbInterface.getConfigurationOrNull(bdescA, "configA2", "catA", 1);
        Assert.assertNotNull((Object)config2bis);
        nextRun4 = dbInterface.getActiveConfigurationRun(descA, "catA");
        ConfigurationRun nextRun5 = new ConfigurationRun(descA, config2bis, t5);
        nextRun5 = dbInterface.populateRunFromPreviousRun(nextRun4, nextRun5, cib.build().getLatestChanges());
        dbInterface.end();
        dbInterface.begin();
        descA = dbInterface.getDescription(descAId);
        ConfigurationRun activeRun = dbInterface.getActiveConfigurationRun(descA, "catA");
        Assert.assertNotNull((String)"there should be an active configuration run", (Object)activeRun);
        dbInterface.end();
        dbInterface.begin();
        descA = dbInterface.getDescription(descAId);
        dbInterface.endRun(descA, t4 + 300L);
        dbInterface.end();
        dbInterface.begin();
        descA = dbInterface.getDescription(descAId);
        activeRun = dbInterface.getActiveConfigurationRun(descA, "catA");
        Assert.assertNull((String)"there should not be an active run", (Object)activeRun);
        dbInterface.end();
        dbInterface.begin();
        Configuration c = dbInterface.getConfigurationOrNull(bdescA, "configA2", "catA", -1);
        Assert.assertEquals((long)config2bis.getId(), (long)c.getId());
        Assert.assertTrue((boolean)c.isLatestVersion());
        dbInterface.end();
        dbInterface.begin();
        HashMap<String, Configuration> map = new HashMap<String, Configuration>();
        map.put(config2.getCategory(), config);
        GlobalConfiguration gc = dbInterface.findGlobalConfigurationOrCreate(bdescA, "global_1", map);
        Assert.assertNotNull((Object)gc);
        Assert.assertEquals((long)0L, (long)gc.getVersion());
        dbInterface.end();
        dbInterface.begin();
        map.put(config2bis.getCategory(), config2bis);
        GlobalConfiguration gc2 = dbInterface.findGlobalConfigurationOrCreate(bdescA, "global_1", map);
        Assert.assertEquals((long)1L, (long)gc2.getVersion());
        dbInterface.end();
    }
}

