package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;

/**
 * Persistence of org.lsst.ccs.bus.messages.BusMessage.
 * @author The LSST CCS Team
 */
@MappedSuperclass
public abstract class MessageData implements Serializable {
    
    private static final long serialVersionUID = 672903267892L;
    
    private long id;
    
    protected AgentDesc agentDesc;
    
    protected long time;
    
    public MessageData() {
        
    }
    
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    public long getId() {
        return id;
    }
    
    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne(optional = false)
    @JoinColumn(name="agentName")
    public AgentDesc getAgentDesc() {
        return agentDesc;
    }

    public void setAgentDesc(AgentDesc agentDesc) {
        this.agentDesc = agentDesc;
    }

    public long getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }
    
}
