package org.lsst.ccs.localdb.utils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import javax.ws.rs.core.MediaType;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
/**
 * A Class to issue requests against the REST server.
 * 
 * @author The LSST CCS Team
 */
public class TrendingConnectionUtils {

    private final Client client = Client.create(new DefaultClientConfig());
    private final String baseUrl;
    private final WebResource serv;
    
    public TrendingConnectionUtils(String serverName, int serverPort) {
        this(serverName,serverPort,"/rest/data");
    }
    
    public TrendingConnectionUtils(String serverName, int serverPort, String entryPoint) {
        baseUrl = String.format("http://%s:%d%s", serverName, serverPort,entryPoint);        
        serv = client.resource(baseUrl).path("dataserver");        
    }
    
    public DataChannel.DataChannelList getChannelList() {
        return serv.path("listchannels").accept(MediaType.TEXT_XML).get(DataChannel.DataChannelList.class);
    }

    public TrendingData getLatestData(String path) {
        return serv.path("data/latest").queryParam("path", path).accept(MediaType.TEXT_XML).get(TrendingData.class);
    }

    public String getBaseUrl() {
        return baseUrl;
    }
    
}
