package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;

import org.lsst.ccs.bus.messages.LogMessage;

@Entity
public class LogMessageData implements Serializable {

    private static final long serialVersionUID = 64234542038176402L;

    private String details, level, logger, source, thread, origin;
    private long id; // do we need this? Perhaps for filter, or whatever
    private long tstamp;

    public LogMessageData() {
        
    }
    
    public LogMessageData(LogMessage log) {
        this.details = log.getFormattedDetails();
        this.level = log.getLevel();
        this.logger = log.getLoggerName();
        this.source = log.getSourceName();
        this.thread = log.getThreadName();
        this.origin = log.getOriginAgentInfo().getName();
        this.tstamp = log.getCCSTimeStamp().getUTCInstant().toEpochMilli();
    }

    
    /**
     * @return the id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    public long getId() {
        return id;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(long id) {
        this.id = id;
    }

    
    public String getDetails() {
        return details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getLogger() {
        return logger;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public String getSource() {
        return source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getThread() {
        return thread;
    }

    public void setThread(String thread) {
        this.thread = thread;
    }

    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }
    
    public long getTstamp() {
        return tstamp;
    }

    public void setTstamp(long tstamp) {
        this.tstamp = tstamp;
    }
    
}
