package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.bus.data.AgentInfo;
/**
 *
 * @author LSST CCS Team
 */
@Entity
@Table(
        uniqueConstraints = @UniqueConstraint(columnNames = {"agentName"}))
@Cacheable
@org.hibernate.annotations.Cache( 
        usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_WRITE
        ,region = "org.lsst.ccs.localdb.statusdb.model.AgentDesc"
)
@Immutable
public class AgentDesc implements Serializable {
   
    private static final long serialVersionUID = 567843891033L;
    
    private AgentInfo.AgentType agentType;
    
    private String agentName;

    /**
     * Default no-arg constructor.
     */
    public AgentDesc() {
    }

    @Id
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    
    public AgentDesc(AgentInfo agentInfo) {
        this.agentName = agentInfo.getName();
        this.agentType = agentInfo.getType();
    }
    
    @Enumerated(EnumType.STRING)
    public AgentInfo.AgentType getAgentType() {
        return agentType;
    }

    public void setAgentType(AgentInfo.AgentType agentType) {
        this.agentType = agentType;
    }

   
    
}
