package org.lsst.ccs.localdb.utils;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import javax.ws.rs.core.MediaType;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
/**
 * A Class to issue requests against the REST server.
 * 
 * @author The LSST CCS Team
 */
public class ClientRequestUtils {

    private final Client client = Client.create(new DefaultClientConfig());
    private final String baseUrl;
    private final WebResource serv;
    
    public ClientRequestUtils(String serverName, int serverPort) {
        baseUrl = String.format("http://%s:%d/rest/data", serverName, serverPort);        
        serv = client.resource(baseUrl).path("dataserver");        
    }
    
    
    public DataChannel.DataChannelList getChannelList() {
        return serv.path("listchannels").accept(MediaType.TEXT_XML).get(DataChannel.DataChannelList.class);
    }
    
}
