package org.lsst.ccs.localdb.configdb.model;

import javax.persistence.*;
import java.io.Serializable;
import java.util.*;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;

/**
 * Represents the static configuration information of an agent.
 * <BR/>
 The baseDescription of a subsystem consists in : 
 <UL>
 * <LI/> The name of the agent on the buses
 * <LI/> The list of {@link ConfigurationParameter} for this agent.
 * </UL>
 */
@Entity
@Immutable
public class Description implements Serializable {

    private static final long serialVersionUID = 1931407188397328132L;
    
    private long id ;
    
    private BaseDescription baseDescription;
    
    /** the set containing all parameter descriptions. */
    private Map<ParameterPath,ConfigurationParameter> finalValues = new HashMap<>();

    protected Description() {
    }
    
    public Description(BaseDescription desc) {
        this.baseDescription = desc;
    }

    ///////////////////////////// ACCESSORS/MUTATORS

    /**
     * the technical id: zero if the object is not yet registered in database
     *
     * @return the id associated with the subsystem baseDescription, as given by the
     * underlying configuration service.
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    public long getId() {
        return id;
    }

    /**
     * used only by reconstruction code
     *
     * @param id
     */
    void setId(long id) {
        this.id = id ;
    }
    
    @Transient
    public AgentDesc getAgentDesc() {
        return baseDescription.getAgentDesc();
    }
    
    public void setBaseDescription(BaseDescription desc) {
        this.baseDescription = desc;
    }
    
    @ManyToOne(fetch = FetchType.EAGER, cascade = CascadeType.ALL)
    public BaseDescription getBaseDescription() {
        return baseDescription;
    }
    
    @ManyToMany(cascade = {CascadeType.PERSIST,CascadeType.ALL}, fetch=FetchType.EAGER)
    @MapKey(name = "parameterPath")
    public Map<ParameterPath, ConfigurationParameter> getFinalValues() {
        return this.finalValues;
    }
    
    void setFinalValues(Map<ParameterPath, ConfigurationParameter> finalValues) {
        this.finalValues = finalValues;
    }
        
    @Override
    public String toString() {
        return "{id=" + getId() + ";descriptions=" + this.getFinalValues()+ '}';
    }

}

