package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Cacheable;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Immutable;


@Entity
@DynamicInsert(true)
@DynamicUpdate(true)
@Table(uniqueConstraints = @UniqueConstraint(columnNames = {"agentName","dataName"})
        ,indexes = {@Index(columnList = "agentName")}
)
//@Immutable
@Cacheable
@org.hibernate.annotations.Cache(
        usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_WRITE
        ,region = "org.lsst.ccs.localdb.statusdb.model.DataDesc"
)
@NamedQueries ( {
    @NamedQuery (
            name = "findDataDesc",
            query = "from DataDesc dd where dd.dataPath.agentName=:agentName and dd.dataPath.dataName=:dataName",
            hints = {@QueryHint(name="org.hibernate.cacheable", value="true")}
    )
})
public class DataDesc implements Serializable {
    
    private static final long serialVersionUID = 2636311585766032024L;
    private long id; // can have a path
    
    private DataPath dataPath;
    private String dataType;
    
    private long lastUpdateTimestamp = 0;
    
    /**
     * @return the id
     */
    @Id()
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    public long getId() {
        return id;
    }
    
    /**
     * @param id
     *            the id to set
     */
    public void setId(long id) {
        this.id = id;
    }

    @Embedded
    @AttributeOverrides({ 
        @AttributeOverride(name = "agentName", column = @Column(name = "agentName", nullable = false)),
        @AttributeOverride(name = "dataName", column = @Column(name = "dataName", nullable = false))
    })
    public DataPath getDataPath() {
        return dataPath;
    }

    public void setDataPath(DataPath dataPath) {
        this.dataPath = dataPath;
    }

    public long getLastUpdateTimestamp() {
        return lastUpdateTimestamp;
    }
    
    public void setLastUpdateTimestamp(long ts) {
        if ( ts > lastUpdateTimestamp ) {
            this.lastUpdateTimestamp = ts;
        }
    }
    
    /**
     * @return the dataType
     */
    @Column(length = 100, name="dataType")
    public String getDataType() {
        return dataType;
    }
    
    /**
     * @param dataType
     *            the dataType to set
     */
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + Objects.hashCode(getDataPath());
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataDesc)) {
            return false;
        }
        final DataDesc other = (DataDesc) obj;
        return getDataPath().equals(other.getDataPath());
    }
    
   
}
