package org.lsst.ccs.localdb.configdb.model;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.lsst.ccs.localdb.statusdb.model.StatusMessageData;

/**
 * Persistent entity corresponding to a StatusConfigurationInfo object.
 * @author LSST CCS Team
 */
@Entity
@Table(
        indexes = {@Index(columnList = "time")}
)
public class ConfigurationInfoData extends StatusMessageData {
    private static final long serialVersionUID = -2820317181512754760L;
    
    private Description description;
    
    // One per category
    private Map<String, ConfigurationRun> configurationRuns = new HashMap<>();
    
    public ConfigurationInfoData() {
        
    }
    
    @ManyToOne
    public Description getDescription() {
        return description;
    }
    
    public void setDescription(Description desc) {
        this.description = desc;
    }
    
    @ManyToMany(fetch = FetchType.EAGER)
    public Map<String, ConfigurationRun> getConfigurationRuns() {
        return configurationRuns;
    }
    
    public void setConfigurationRuns(Map<String, ConfigurationRun> runs) {
        this.configurationRuns.putAll(runs);
        
    }
    
    @Transient
    public String getConfigurationDescriptionString() {
        StringBuilder sb = new StringBuilder(description.getAgentDesc().getAgentName());
        // Finding the global configuration
        GlobalConfiguration globalConfiguration = null;
        for (ConfigurationRun cr : configurationRuns.values()) {
            if(cr.getGlobalConfiguration() == null) {
                break;
            } else if (globalConfiguration != null) {
                if (globalConfiguration.getId() != cr.getGlobalConfiguration().getId()) {
                    break;
                }
            } else {
                globalConfiguration = cr.getGlobalConfiguration();
            }
        }
        if(globalConfiguration != null) {
            sb.append("[").append(globalConfiguration.getName())
                    .append("(").append(globalConfiguration.getVersion()).append(")").append("]");
        }
        sb.append("[");
        Map<String, ConfigurationRun> orderedMap = new TreeMap<>(configurationRuns);
        for(Map.Entry<String, ConfigurationRun> e : orderedMap.entrySet()) {
            sb.append(e.getValue().getConfigurationDescriptionString())
                    .append(",");
        }
        sb.deleteCharAt(sb.length()-1).append("]");
        return sb.toString();
    }
}
