package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import javax.persistence.Column;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(
        indexes = {@Index(columnList = "dataDescId"), @Index(columnList="time")}
)
public class PlotData implements Serializable {

    private static final long serialVersionUID = 345359964480234719L;
    private long id; // do we need this? Perhaps for filter, or whatever
    private DataDesc dataDesc;
    private long time;
    private String plotData;

    /**
     * @return the id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    public long getId() {
        return id;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * @return the dataDesc
     */
    @ManyToOne
    public DataDesc getDataDesc() {
        return dataDesc;
    }

    /**
     * @param dataDesc
     *            the dataDesc to set
     */
    public void setDataDesc(DataDesc dataDesc) {
        this.dataDesc = dataDesc;
    }

    /**
     * @return the time
     */
    public long getTime() {
        return time;
    }

    /**
     * @param time
     *            the time to set
     */
    public void setTime(long time) {
        this.time = time;
    }

    /**
     * @return the plotData
     */
    @Lob
    @Column(length = 1024 * 1024)
    public String getPlotData() {
        return plotData;
    }

    /**
     * @param plotData
     *            the plotData to set
     */
    public void setPlotData(String plotData) {
        this.plotData = plotData;
    }
}
