package org.lsst.ccs.localdb.statusdb.model;

import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;

/**
 * Persistence for StatusStateChangeNotification messages.
 * @author LSST CCS Team
 */
@Entity
public class StateChangeNotificationData extends StatusMessageData {
  
    private static final long serialVersionUID = 634282908394L;
    
    private AgentState oldState;
    
    public StateChangeNotificationData() {
        
    }

    @ManyToOne
    public AgentState getOldState() {
        return oldState;
    }

    public void setOldState(AgentState data) {
        this.oldState = data;
    }
    
    @Transient
    public AgentState getNewState() {
        return getAgentState();
    }
}
