/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.server;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.DataServer;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;

public class RestDataTest
extends LocaldbTestTemplate {
    private static DataServer ds;
    private static Map<String, DataChannel> channels;
    private static long tstart;
    private static long tstop;
    private static long tstart5;
    private static long tstop5;

    @BeforeClass
    public static void initClass() throws Exception {
        p.setProperty("hibernate.dialect", "org.hibernate.dialect.HSQLDialect");
        p.setProperty("hibernate.connection.driver_class", "org.hsqldb.jdbcDriver");
        p.setProperty("hibernate.connection.url", "jdbc:hsqldb:file:target/test-classes/testrestdatadb");
        p.setProperty("hibernate.connection.username", "root");
        p.setProperty("hibernate.connection.password", "");
        p.setProperty("hibernate.hbm2ddl.auto", "update");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        ds = new DataServer();
        channels = RestDataTest.ds.getChannels().list.stream().collect(Collectors.toMap(dc -> dc.getPathAsString(), c -> c));
        Session sess = sessionFactory.openSession();
        Object[] minMax = (Object[])sess.createQuery("select min(rd.time), max(rd.time) from RawData rd").uniqueResult();
        tstart = (Long)minMax[0];
        tstop = (Long)minMax[1];
        System.out.println("tstart : " + new Date(tstart) + "; tstop : " + new Date(tstop));
        sess.close();
        sess = sessionFactory.openSession();
        tstart5 = (Long)sess.createQuery("select min(sti.startTime) from StatTimeInterval sti where sti.binWidth = 300000 and sti.startTime >= :tstart").setLong("tstart", tstart).uniqueResult();
        tstop5 = (Long)sess.createQuery("select max(sti.endTime) from StatTimeInterval sti where sti.binWidth = 300000 and sti.endTime < :tstop").setLong("tstop", tstop).uniqueResult();
        System.out.println("tstart5 : " + new Date(tstart5) + "; tstop5 : " + new Date(tstop5));
        sess.close();
    }

    @Test
    public void testGetData() throws Exception {
        String channel = "/demo-subsystem/demo_Data/sine";
        long channelId = channels.get(channel).getId();
        Map availableStats = ds.getAvailableStats(channelId, tstart, tstop);
        Assert.assertEquals((String)"there should be at least two stat data available", (long)2L, (long)availableStats.size());
        StatDesc sd5 = null;
        for (StatDesc sd : availableStats.keySet()) {
            if (sd.getTimeBinWidth() != 300000L) continue;
            sd5 = sd;
            break;
        }
        List sds = ds.getStatData(sd5, tstart5, tstop5);
        int nin = sds.size();
        Assert.assertNotEquals((String)"there should be data", (long)0L, (long)nin);
        Data dataFromStat = ds.getData(channelId, tstart5, tstop5, "stat", nin);
        Data dataFromRaw = ds.exportStatDataFromRaw(channelId, tstart5, tstop5, nin);
        Assert.assertEquals((String)"size of returned data", (long)nin, (long)dataFromStat.getTrendingResult().getTrendingDataArray().length);
        for (int i = 0; i < nin; ++i) {
            StatData sd = (StatData)sds.get(i);
            TrendingData tds = dataFromStat.getTrendingResult().getTrendingDataArray()[i];
            TrendingData tdr = dataFromRaw.getTrendingResult().getTrendingDataArray()[i];
            Assert.assertEquals((String)(i + "th lower edge"), (long)sd.getStatTimeInterval().getStartTime(), (long)tds.getAxisvalue().getLoweredge());
            Assert.assertEquals((String)(i + "th upper edge"), (long)sd.getStatTimeInterval().getEndTime(), (long)tds.getAxisvalue().getUpperedge());
            Assert.assertEquals((String)(i + "th min"), (double)sd.getMin(), (double)tds.getValue("min"), (double)0.0);
            Assert.assertEquals((String)(i + "th min"), (double)sd.getMin(), (double)tdr.getValue("min"), (double)0.0);
            Assert.assertEquals((String)(i + "th max"), (double)sd.getMax(), (double)tds.getValue("max"), (double)0.0);
            Assert.assertEquals((String)(i + "th max"), (double)sd.getMax(), (double)tdr.getValue("max"), (double)0.0);
            Assert.assertEquals((String)(i + "th rms"), (double)sd.getRMS(), (double)tds.getValue("rms"), (double)0.0);
            Assert.assertEquals((String)(i + "th rms"), (double)sd.getRMS(), (double)tdr.getValue("rms"), (double)1.0E-6);
            Assert.assertEquals((String)(i + "th value"), (double)sd.getAverage(), (double)tds.getValue("value"), (double)0.0);
            Assert.assertEquals((String)(i + "th value"), (double)sd.getAverage(), (double)tdr.getValue("value"), (double)1.0E-7);
        }
    }

    @Test
    public void testMetaData() throws Exception {
        String channel = "/demo-subsystem/demo_Data/sine";
        long channelId = channels.get(channel).getId();
        Session sess = sessionFactory.openSession();
        DataDesc dd = (DataDesc)sess.createQuery("from DataDesc where agentName='demo-subsystem' and dataName='demo_Data/sine'").uniqueResult();
        Assert.assertNotNull((Object)dd);
        sess.createSQLQuery("insert into ccs_dataGroup(id, agentName, groupName) select id, agentName, dataName from ccs_dataDesc where id=" + dd.getId()).executeUpdate();
        sess.createSQLQuery("insert into ccs_dataGr_dataDe_b (dataGroupId,membersId) select id, id from ccs_dataDesc where id=" + dd.getId()).executeUpdate();
        sess.close();
        List mdl = ds.getMetadataForChannel((int)channelId, tstart, tstop);
        mdl.sort((md1, md2) -> Long.compare(md1.getTstart(), md2.getTstart()));
        int size = mdl.size();
        Assert.assertNotEquals((String)"meta data list should not be empty", (long)0L, (long)size);
        Assert.assertEquals((String)"last metadata should not have end date", (long)-1L, (long)((ChannelMetaData)mdl.get(size - 1)).getTstop());
    }
}

