package org.lsst.ccs.localdb.statusdb.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.lsst.ccs.bus.states.AlertState;

/**
 * Persistent counterpart of a StatusRaisedAlert.
 * @author LSST CCS Team
 */
@Entity
@Table(
        indexes = {@Index(columnList = "time")}
)
public class RaisedAlertData extends AlertData {
    private static final long serialVersionUID = -9007475175629577314L;
    private static final int CAUSE_lENGTH = 255;
    /**
     * Current severity for this alert.
     */
    protected AlertState severity;
    
    private ClearedAlertData clearingAlert;
    
    private Boolean active = true;
    
    protected String alertCause;

    public RaisedAlertData() {
        
    }
    
    public RaisedAlertData(AlertState severity, String alertCause, long timestamp) {
        this.severity = severity;
        setAlertCause(alertCause);
        this.time = timestamp;
    }
    
    public void setSeverity(AlertState alertState) {
        this.severity = alertState;
    }

    @Enumerated(EnumType.STRING)
    public AlertState getSeverity() {
        return severity;
    }

    public Boolean isActive() {
        return active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }
    
    @Column(length = CAUSE_lENGTH)
    public String getAlertCause() {
        return alertCause;
    }

    public void setAlertCause(String alertCause) {
        if (alertCause.length()>CAUSE_lENGTH) {
            alertCause = alertCause.substring(0, CAUSE_lENGTH);
        }
        this.alertCause = alertCause;
    }

    @ManyToOne(optional = true)
    public ClearedAlertData getClearingAlert() {
        return clearingAlert;
    }

    public void setClearingAlert(ClearedAlertData clearingAlert) {
        this.clearingAlert = clearingAlert;
    }
    
}
