package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import org.hibernate.annotations.Immutable;

@Embeddable
@Immutable
public class DataPath implements Serializable {
    
    private static final long serialVersionUID = -8144353557197597425L;
    
    protected String agentName;
    
    protected String dataName;
    
    public DataPath() {
        
    }
    
    public DataPath(String agentName, String dataName) {
        this.agentName = agentName;
        this.dataName = dataName;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getDataName() {
        return dataName;
    }

    public void setDataName(String dataName) {
        this.dataName = dataName;
    }
    
    @Transient
    public String getFullKey() {
        return agentName+"/"+dataName;
    }
    
    // or have the path in some other metadata to build the JAS tree.
    // ?? String path; // for JAS
    // ?? String label; // for JAS : label as it appears in tree
    // when JAS plotting the axes labels can still be something different.
    // used in Fermi to have different views (shifter/engineers)
    // TODO publish the list of all variables with a web service REST
    @Transient
    public String[] getPath() {
        String[] namePath = getDataName().split("/");
        String[] result = new String[namePath.length + 1];
        result[0] = getAgentName();
        for (int i = 1; i < result.length; i++) {
            result[i] = namePath[i - 1];
        }
        return result;
    }
    
    public static String encodePath(String[] path) {
        // escape slashs
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < path.length; i++) {
            result.append('/');
            result.append(path[i].replaceAll("/", "\\\\/"));
        }
        return result.toString();
    }
    
    public static String[] decodePath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] elts = path.split("(?<!\\\\)/");
        for (int i = 0; i < elts.length; i++) {
            elts[i] = elts[i].replaceAll("\\\\/", "/");
        }
        return elts;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 13 * hash + Objects.hashCode(getAgentName());
        hash = 13 * hash + Objects.hashCode(getDataName());
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPath)) {
            return false;
        }
        final DataPath other = (DataPath) obj;
        if (!getAgentName().equals(other.getAgentName())) {
            return false;
        }
        if (!getDataName().equals(other.getDataName())) {
            return false;
        }
        return true;
    }
    
    @Override
    public String toString() {
        return getFullKey();
    }
    
    
}
    