/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.dao;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.localdb.configdb.model.Configuration;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameter;
import org.lsst.ccs.localdb.configdb.model.ConfigurationRun;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.GlobalConfiguration;
import org.lsst.ccs.localdb.configdb.model.HibernateDAO;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;

public class ConfigHibernateTest
extends LocaldbTestTemplate {
    private static HibernateDAO dbInterface;

    @BeforeClass
    public static void setupClass() throws Exception {
        System.setProperty("hsqldb.reconfig_logging", "true");
        System.setProperty("org.jboss.logging.provider", "jdk");
        Logger.getLogger("hsqldb.db").setLevel(Level.OFF);
        Logger.getLogger("org.hibernate").setLevel(Level.OFF);
        Logger.getLogger("org.jboss").setLevel(Level.OFF);
        p.setProperty("hibernate.use_sql_comments", "false");
        p.setProperty("hibernate.show_sql", "false");
        p.setProperty("hibernate.format_sql", "false");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        dbInterface = new HibernateDAO(sessionFactory);
    }

    @Before
    public void init() {
    }

    @Test
    public void testScenarios() throws Exception {
        dbInterface.begin();
        AgentDesc ad = new AgentDesc(new AgentInfo("someName", AgentInfo.AgentType.WORKER));
        dbInterface.persist((Object)ad);
        HashMap<String, ConfigurationParameterInfo> cpis = new HashMap<String, ConfigurationParameterInfo>();
        cpis.put("main/info", new ConfigurationParameterInfo("main/info", "catA", "java.lang.String", false, "", "", false, ""));
        cpis.put("main/max", new ConfigurationParameterInfo("main/max", "catA", "java.lang.Integer", false, "", "", false, ""));
        cpis.put("son/max", new ConfigurationParameterInfo("son/max", "catA", "java.lang.Integer", false, "", "", false, ""));
        Description descA = dbInterface.findDescriptionOrCreate(ad, new ArrayList(cpis.values()));
        Assert.assertNotEquals((String)"size of parameter description should be >0", (long)0L, (long)descA.getConfigurationParameters().size());
        Assert.assertNotNull((Object)descA);
        long descAId = descA.getId();
        Assert.assertTrue((String)"id of subsystem description should be > 0", (descA.getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"number of attached configuration parameters : ", (long)3L, (long)descA.getConfigurationParameters().size());
        Description sameDescA = dbInterface.findDescriptionOrCreate(ad, new ArrayList(cpis.values()));
        Assert.assertEquals((long)descA.getId(), (long)sameDescA.getId());
        ArrayList<ConfigurationParameterInfo> cpisB = new ArrayList<ConfigurationParameterInfo>();
        cpisB.add(new ConfigurationParameterInfo("main/info", "", "java.lang.String", false, "", "", false, ""));
        cpisB.add(new ConfigurationParameterInfo("main/max", "catA", "java.lang.Integer", false, "", "", false, ""));
        cpisB.add(new ConfigurationParameterInfo("son/max", "catB", "java.lang.Integer", false, "", "", false, ""));
        Description descB = dbInterface.findDescriptionOrCreate(ad, cpisB);
        Assert.assertTrue((String)"id of subsystem description should be > 0", (descB.getId() > 0L ? 1 : 0) != 0);
        Assert.assertNotEquals((String)"the description entity should be different", (long)descA.getId(), (long)descB.getId());
        long t0 = System.currentTimeMillis();
        Configuration config = dbInterface.getConfigurationOrCreate(descA, "configA1", "catA", -3, new ArrayList(cpis.values()), t0, null);
        ConfigurationRun run = new ConfigurationRun(config, t0);
        dbInterface.populateRunFromScratch(run, Collections.emptyList());
        Assert.assertNotNull((Object)dbInterface.getConfigurationOrNull(descA, "configA1", "catA", 0));
        HashSet distinctCP = new HashSet();
        distinctCP.addAll(descA.getConfigurationParameters().values().stream().map(ConfigurationParameter::getId).collect(Collectors.toSet()));
        distinctCP.addAll(descB.getConfigurationParameters().values().stream().map(ConfigurationParameter::getId).collect(Collectors.toSet()));
        Assert.assertEquals((String)("number of distinct configuration parameters : " + distinctCP), (long)5L, (long)distinctCP.size());
        long t1 = t0 + 300L;
        ConfigurationParameterInfo cpi = new ConfigurationParameterInfo("main/max", "catA", "java.lang.Integer", false, "", "2000", false, "");
        ConfigurationRun nextRun = new ConfigurationRun(config, t1);
        nextRun = dbInterface.populateRunFromPreviousRun(run, nextRun, Arrays.asList(cpi));
        long t2 = t1 + 300L;
        cpi = new ConfigurationParameterInfo("son/max", "catA", "java.lang.Integer", false, "", "3000", false, "");
        cpis.put(cpi.getPathName(), cpi);
        ConfigurationRun nextRun2 = new ConfigurationRun(config, t2);
        nextRun2 = dbInterface.populateRunFromPreviousRun(nextRun, nextRun2, Arrays.asList(cpi));
        long t3 = t2 + 300L;
        Configuration config2 = dbInterface.getConfigurationOrCreate(descA, "configA2", "catA", -3, new ArrayList(cpis.values()), t3, nextRun2);
        Assert.assertEquals((long)0L, (long)config2.getVersion());
        ConfigurationRun nextRun3 = new ConfigurationRun(config2, t3);
        nextRun3 = dbInterface.populateRunFromPreviousRun(nextRun2, nextRun3, Collections.emptyList());
        long t4 = t3 + 300L;
        cpi = new ConfigurationParameterInfo("main/max", "catA", "java.lang.Integer", false, "", "4000", false, "");
        ConfigurationRun nextRun4 = new ConfigurationRun(config2, t4);
        nextRun4 = dbInterface.populateRunFromPreviousRun(nextRun3, nextRun4, Arrays.asList(cpi));
        long t5 = t4 + 300L;
        cpis.put(cpi.getPathName(), new ConfigurationParameterInfo("main/max", "catA", "java.lang.Integer", false, "4000", "4000", false, ""));
        Configuration config2bis = dbInterface.getConfigurationOrCreate(descA, "configA2", "catA", -3, new ArrayList(cpis.values()), t5, nextRun4);
        Assert.assertEquals((long)1L, (long)config2bis.getVersion());
        ConfigurationRun nextRun5 = new ConfigurationRun(config2bis, t5);
        nextRun5 = dbInterface.populateRunFromPreviousRun(nextRun4, nextRun5, Arrays.asList(cpi));
        dbInterface.end();
        dbInterface.begin();
        descA = dbInterface.getDescription(descAId);
        ConfigurationRun activeRun = dbInterface.getActiveConfigurationRun(descA, "catA");
        Assert.assertNotNull((Object)activeRun);
        dbInterface.end();
        dbInterface.begin();
        descA = dbInterface.getDescription(descAId);
        dbInterface.endRun(descA, t4 + 300L);
        dbInterface.begin();
        descA = dbInterface.getDescription(descAId);
        activeRun = dbInterface.getActiveConfigurationRun(descA, "catA");
        Assert.assertNull((Object)activeRun);
        dbInterface.end();
        dbInterface.begin();
        HashMap<String, Configuration> map = new HashMap<String, Configuration>();
        map.put(config2.getCategory(), config);
        GlobalConfiguration gc = dbInterface.findGlobalConfigurationOrCreate(descA, "global_1", map);
        Assert.assertNotNull((Object)gc);
        Assert.assertEquals((long)0L, (long)gc.getVersion());
        dbInterface.end();
        dbInterface.begin();
        map.put(config2bis.getCategory(), config2bis);
        GlobalConfiguration gc2 = dbInterface.findGlobalConfigurationOrCreate(descA, "global_1", map);
        Assert.assertEquals((long)1L, (long)gc2.getVersion());
        dbInterface.end();
    }
}

