package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Represents a state change for a given subsystem. It is made of a timestamp
 * and a list of state transitions (state enum class and its new enm value)
 *
 * @author LSST CCS Team
 */
public class StateChange implements Serializable {
    
    private static final long serialVersionUID = -8107539135905934548L;

    @XmlElement(name = "state")
    private List<StateEvent> stateEvents = new ArrayList<>();
        
    @XmlAttribute
    private long time;
    
    public void setTime(long time) {
        this.time = time;
    }
    
    public void addStateEvent(String componentName, String enumClassName, String enumValue) {
        stateEvents.add(new StateEvent(componentName, enumClassName, enumValue));
    }
    
    public boolean containsEvent(String componentName, String enumClassName) {
        for(StateEvent se : stateEvents) {
            if (se.componentName.equals(componentName) && se.name.equals(enumClassName)) {
                return true;
            }
        }
        return false;
    }
    
    public boolean isEmpty() {
        return stateEvents.isEmpty();
    }
    
    @XmlRootElement(name = "statechanges")
    public static class StateChangesList {
        
        @XmlElement(name = "statechange")
        public List<StateChange> list;

        public StateChangesList(List<StateChange> list) {
            this.list = list;
        }

        public StateChangesList() {
        }
        
    }
    
}
