package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;

@Entity
//@DynamicUpdate(true)
//@DynamicInsert(true)
@Table(uniqueConstraints = @UniqueConstraint(columnNames = {"dataDescId","timeBinWidth"}),
        indexes = {@Index(columnList = "dataDescId")}
)
@Immutable
@Cacheable
@org.hibernate.annotations.Cache( 
        usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_ONLY
        ,region = "org.lsst.ccs.localdb.statusdb.model.StatDesc"
)
public class StatDesc implements Serializable {
    private static final long serialVersionUID = -4640537966560757206L;

    private long id;
    private DataDesc dataDesc;
    private long timeBinWidth;

    /**
     * @return the id
     */
    @Id()
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    public long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * @return the dataDesc
     */
    @ManyToOne
    public DataDesc getDataDesc() {
        return dataDesc;
    }

    /**
     * @param dataDesc the dataDesc to set
     */
    public void setDataDesc(DataDesc dataDesc) {
        this.dataDesc = dataDesc;
    }

    /**
     * @return the timeBinWidth
     */
    public long getTimeBinWidth() {
        return timeBinWidth;
    }

    /**
     * @param timeBinWidth the timeBinWidth to set
     */
    public void setTimeBinWidth(long timeBinWidth) {
        this.timeBinWidth = timeBinWidth;
    }
}
