package org.lsst.ccs.localdb.configdb.model;

import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import java.io.Serializable;

/**
 * abstract class for all parameter configurations
 * @author bamade
 */
// Date: 11/04/12

@MappedSuperclass
public abstract class ParameterConfiguration  implements Serializable, PathObject{
    
    private static final long serialVersionUID = 774337848554181101L;
    
    /**
     * This is the configured value corresponding to the current configuration
     * for this parameter
     */
    protected String value ;

    /**
     * this transient field is to carry information about a failure in configuration "repair".
     * The corresponding parameter cannot be matched to a new <TT>SubsystemDescription</TT>
     * to which we try to attach this (possibly deprecated) Configuration.
     */
    @Transient
    protected Exception reConfigurationFailure ;


    ///////////////////////// CONSTRUCTORS

    protected ParameterConfiguration() {

    }
    protected ParameterConfiguration(String value) {
        this.value = value;
    }


    /////////////////////////// ACCESSORS/MUTATORS

    public abstract long getId() ;
    protected abstract void setId(long id) ;

    public boolean isReadOnly() {
        return getId() != 0L ;
    }

    public Exception getReConfigurationFailure() {
        return reConfigurationFailure;
    }

    public void setReConfigurationFailure(Exception reConfigurationFail) {
        this.reConfigurationFailure = reConfigurationFail;
    }

    public abstract ParameterDescription getDescription() ;

    /**
     * @return the configured value for this parameter
     */
    public String getValue() {
        return value;
    }

    void setValue(String value) {
        /* if( isReadOnly()) {
            throw new ImmutableStateException("read only value") ;
        } */
        this.value = value;
    }

    /**
     * Modifies the value field
     * @param value
     * @throws ImmutableStateException if modification is for a registered object
     * @throws IllegalArgumentException if value is not coherent with type and constraints
     */
    public void modifyValue(String value){
        if( isReadOnly()){
            throw new ImmutableStateException("read only value");
        }
        setValue(value);
    }
    ///////////////////////////// IDENT METHODS
    // TODO: add id?

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof PathObject)) return false;

        PathObject that = (PathObject) o;
        ParameterDescription description = getDescription();
        if (!description.getPath().equals(that.getPath())) return false;

        return true;
    }

    @Override
    public String toString() {
        return  this.getId() + "{" + getId() +
                ": description=" + getDescription() +
                ", value='" + value + '\'' +
                '}';
    }

    @Override
    public int hashCode() {
        return getDescription().hashCode();
    }

    @Override
    public ParameterPath getPath() {
        return getDescription().getPath();
    }
    
    public boolean hasChanged(){
        return false;
    }
}
