package org.lsst.ccs.localdb.configdb.model;

import java.util.Collection;
import java.util.List;

/* TODO:
 *  - may be create a "default" profile every time we create a description (name being empty)
 *  - get a description of a subsystem at a given moment in time
 *  -get all Profiles pointing to a description (be it active or not!)
 *  - get a parameter value for a subsystem at any given moment in time
 *  (this is tricky because some parameters are not modifiable and so should be in the description)
 *
 */
/**
 * defines the basic methods implemented by a Data Access Object.
 * Note that many org.lsst.gruth.types are package protected so implementors whould be in the same package.
 * @author bamade
 */
// Date: 13/04/12

public interface DBInterface {
    /**
     * starts a transaction
     */
    public void begin() ;

    /**
     * end a transaction
     */
    public void end() ;

    /**
     * failure: must close transaction
     */
    public void fail() ;

    /**
     * same as fail but a Throwable can be used to log.
     * @param th
     */
    public void fail(Throwable th) ;


    /**
     * saves the argument: which must now becomes immutable and be numbered (with an ID)
     * @param newDescription
     */
    public void saveSubsystemDescription (ASubsystemDescription newDescription) ;

    /**
     * saves the argument
     * @param ghosts
     */
    public void saveGhostDescriptions (GhostSubsystemDescription ghosts);

    /**
     *  gets a SubsystemDescription in the corresponding active object table.
     * @param name
     * @param tag
     * @return null if not found
     */
    public ASubsystemDescription getActiveSubsystemDescription(String name, String tag) ;

    /**
     * gets a subsystem description by its id
     * @param id
     * @return the active subsystem description that matches the given id
     */
    public ASubsystemDescription getActiveSubsystemDescription(long id) ;

    /**
     * returns ghost with corresponding id
     * @param id
     * @return null if not found
     */
    public GhostSubsystemDescription getGhostDescription(long id) ;

    /**
     * deletes an active description
     * @param oldDescription
     */
    public void deleteActiveSubsystemDescription(ASubsystemDescription oldDescription) ;

    /**
     * saves the new argument: ID is modified and argument becomes immutable.
     * @param newProfile
     */
    public void saveConfigProfile(AConfigProfile newProfile) ;
    // marks the Ghost's end date

    /**
     * saves argument
     * @param deprecatedProfile
     */
    public void savePastProfile(PastConfigProfile deprecatedProfile) ;

    /**
     * get configProfile with name and tag
     * @param subsystemName the subsystem name
     * @param descriptionName the description name
     * @param name 
     * @param tag
     * @return null if not found
     */
    public AConfigProfile getActiveConfigProfile(String subsystemName, String descriptionName, String name, String tag);
    
    /**
     * delectes the active profile from DB
     * @param oldProfile
     */
    public void deleteActiveConfigProfile(AConfigProfile oldProfile) ;

    /**
     * registers a modified  parameter
     * @param config
     */
    public void modifyParmConfig(AParameterConfiguration config) ;

    /**
     * gets the active configProfiles that references an active SubsystemDescription
     * @param description
     * @return a Collection of active {@code AConfigProfile} for the active
     * {@code ASubsystemDescription}
     */
    public Collection<AConfigProfile> getActiveProfilesForSubsystem(ASubsystemDescription description, String category) ;

    /**
     * get the deprecated ConfigProfile that referenced a subsystemDescription (active or deprecated)
     * @param description
     * @return a Collection of config profiles that referenced the subsystem description
     */
    public Collection<PastConfigProfile> getProfilesForSubsystem(GhostSubsystemDescription description) ;

    /**
     * saves a run history
     * @param runHistory
     */
    public void saveRun(RunHistory runHistory) ;

    /**
     * execut simple request (read only: select of From)
     * @param hqlString
     * @return an HQL request
     */
    public List<?> simpleHQLRequest(String hqlString) ;

    /**
     * claose all
     */
    public void close() ;
}
