/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.dao;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.localdb.configdb.dao.HibernateDAO;
import org.lsst.ccs.localdb.configdb.dao.TztDeprecationListener;
import org.lsst.ccs.localdb.configdb.model.ConfigProfile;
import org.lsst.ccs.localdb.configdb.model.ConfigurationFacade;
import org.lsst.ccs.localdb.configdb.model.DBInterface;
import org.lsst.ccs.localdb.configdb.model.DeprecationListener;
import org.lsst.ccs.localdb.configdb.model.Factories;
import org.lsst.ccs.localdb.configdb.model.ParameterBase;
import org.lsst.ccs.localdb.configdb.model.ParameterDescription;
import org.lsst.ccs.localdb.configdb.model.SubsystemDescription;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;

public class ConfigHibernateTest
extends LocaldbTestTemplate {
    private static ConfigurationFacade configurationFacade;

    @BeforeClass
    public static void setupClass() throws Exception {
        System.setProperty("hsqldb.reconfig_logging", "true");
        System.setProperty("org.jboss.logging.provider", "jdk");
        Logger.getLogger("hsqldb.db").setLevel(Level.OFF);
        Logger.getLogger("org.hibernate").setLevel(Level.OFF);
        Logger.getLogger("org.jboss").setLevel(Level.OFF);
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        HibernateDAO hibernateDAO = new HibernateDAO(sessionFactory);
        configurationFacade = new ConfigurationFacade((DBInterface)hibernateDAO);
        TztDeprecationListener deprecationListener = new TztDeprecationListener();
        configurationFacade.setDeprecationListener((DeprecationListener)deprecationListener);
    }

    @Before
    public void init() {
    }

    @Test
    public void testScenarios() throws Exception {
        String descA = "configurationA";
        SubsystemDescription subsystemDescriptionA = Factories.createRawSubsystemDescription((String)"subA", (String)"configurationA", (Serializable)((Object)""));
        subsystemDescriptionA.addParameterDescriptions(new ParameterDescription[]{Factories.createParameterDescription((ParameterBase)new ParameterBase("main", "", "info", "java.lang.String", "testMain"), (String)"", (String)"", (String)"", (int)0)});
        subsystemDescriptionA.addParameterDescriptions(new ParameterDescription[]{Factories.createParameterDescription((ParameterBase)new ParameterBase("main", "", "max", "java.lang.Integer", "2000"), (String)"", (String)"", (String)"", (int)0)});
        subsystemDescriptionA.addParameterDescriptions(new ParameterDescription[]{Factories.createParameterDescription((ParameterBase)new ParameterBase("son", "", "max", "java.lang.Integer", "1000"), (String)"", (String)"", (String)"", (int)0)});
        Assert.assertNotNull((Object)subsystemDescriptionA);
        String subNameA = subsystemDescriptionA.getSubsystemName();
        String descriptionNameA = subsystemDescriptionA.getTag();
        SubsystemDescription subsystemDescriptionB = Factories.createRawSubsystemDescription((String)"subB", (String)"configurationB", (Serializable)((Object)""));
        subsystemDescriptionB.addParameterDescriptions(new ParameterDescription[]{Factories.createParameterDescription((ParameterBase)new ParameterBase("aComp", "", "parmName", "java.lang.String", ""), (String)"", (String)"", (String)"", (int)0)});
        Assert.assertNotNull((Object)subsystemDescriptionB);
        configurationFacade.registerSubsystemDescription(subsystemDescriptionA);
        ConfigProfile defaultProfileA = Factories.createRawConfigProfile((SubsystemDescription)subsystemDescriptionA, (String)"", (String)"");
        configurationFacade.registerConfigProfile(defaultProfileA);
        System.out.println("registered subsystem description " + subsystemDescriptionA);
        System.out.println("registered default configuration" + defaultProfileA);
        long idA = subsystemDescriptionA.getId();
        Assert.assertTrue((String)"id of subsystem description should be > 0", (idA > 0L ? 1 : 0) != 0);
        Assert.assertNotNull((String)("default profile problem ? " + defaultProfileA), (Object)defaultProfileA);
        Assert.assertEquals((String)("default profile problem ? " + defaultProfileA), (Object)":", (Object)defaultProfileA.getName());
        configurationFacade.registerSubsystemDescription(subsystemDescriptionB);
        ConfigProfile defaultProfileB = Factories.createRawConfigProfile((SubsystemDescription)subsystemDescriptionB, (String)"", (String)"");
        configurationFacade.registerConfigProfile(defaultProfileB);
        System.out.println("registered subsystem description " + subsystemDescriptionB);
        System.out.println("registered default configuration" + defaultProfileB);
        Assert.assertTrue((String)"id of subsystem description should be > 0", (subsystemDescriptionB.getId() > 0L ? 1 : 0) != 0);
        Assert.assertNotNull((String)("default profile problem ? " + defaultProfileB), (Object)defaultProfileB);
        Assert.assertEquals((String)("default profile problem ? " + defaultProfileB), (Object)":", (Object)defaultProfileB.getName());
        configurationFacade.registerSubsystemDescription(subsystemDescriptionA);
        Assert.assertEquals((String)"same registration should not change object", (long)idA, (long)subsystemDescriptionA.getId());
        List l = configurationFacade.simpleHQLRequest("from AConfigProfile");
        Assert.assertEquals((String)("there should be 2 different default profiles :" + l), (long)2L, (long)l.size());
        ConfigProfile configProfileA1 = Factories.createRawConfigProfile((SubsystemDescription)subsystemDescriptionA, (String)"", (String)"config1");
        Assert.assertNotNull((String)"initial profile should not be null", (Object)configProfileA1);
        ConfigProfile staticConfigProfile = Factories.copyProfile((ConfigProfile)defaultProfileA, (String)"config2");
        Assert.assertNotNull((String)"initial profile should not be null", (Object)staticConfigProfile);
        ConfigProfile failConfigProfile = Factories.copyProfile((ConfigProfile)defaultProfileA, (String)"config3");
        Assert.assertNotNull((String)"initial profile should not be null", (Object)failConfigProfile);
        configProfileA1.addParameterConfiguration("main//max", "2000");
        staticConfigProfile.addParameterConfiguration("main//max", "2000");
        failConfigProfile.addParameterConfiguration("main//max", "2000");
        staticConfigProfile.addParameterConfiguration("main//info", "static!");
        staticConfigProfile.addParameterConfiguration("main//max", "10");
        failConfigProfile.addParameterConfiguration("main//value", "-2000.0");
        System.out.println("Registering configProfileA");
        configurationFacade.registerConfigProfile(configProfileA1);
        Assert.assertTrue((String)"id of profile should be >0", (configProfileA1.getId() > 0L ? 1 : 0) != 0);
        System.out.println("Registering configProfileB");
        configurationFacade.registerConfigProfile(staticConfigProfile);
        Assert.assertTrue((String)"id of profile should be >0", (staticConfigProfile.getId() > 0L ? 1 : 0) != 0);
        Thread.sleep(200L);
        long start1 = System.currentTimeMillis();
        long end1 = start1 + 2000L;
        long middle1 = (start1 + end1) / 2L;
        System.out.println("Registering run for configurationA");
        configurationFacade.registerRun(subNameA, ":config1", descA, start1);
        SubsystemDescription description = configurationFacade.getActiveSubsystemDescription(subNameA, descA);
        Assert.assertNotNull((String)("could not find active subsystem description with subsystem name : " + subNameA), (Object)description);
        System.out.println("DESCRIPTION QUERY YIELDS " + description);
        Assert.assertNotEquals((String)"size of parameter description should be >0", (long)0L, (long)description.getParamDescriptionMap().size());
        ConfigProfile runningConfig = configurationFacade.getConfigRunningAt(subNameA, descriptionNameA, "", middle1);
        Assert.assertNotNull((Object)runningConfig);
        Assert.assertEquals((Object)":config1", (Object)runningConfig.getName());
        String value = configurationFacade.getActiveValueAt(subNameA, descriptionNameA, "", "main//info", middle1);
        Assert.assertEquals((Object)"testMain", (Object)value);
        value = configurationFacade.getActiveValueAt(subNameA, descriptionNameA, "", "main//max", middle1);
        Assert.assertEquals((Object)"2000", (Object)value);
        configurationFacade.endRun(subNameA, "config1", descA, end1);
        value = configurationFacade.getActiveValueAt(subNameA, descriptionNameA, "", "main//info", middle1);
        Assert.assertEquals((Object)"testMain", (Object)value);
        value = configurationFacade.getActiveValueAt(subNameA, descriptionNameA, "", "main//max", middle1);
        Assert.assertEquals((Object)"2000", (Object)value);
        long start2 = end1 + 1000L;
        long end2 = start2 + 2000L;
        long middle2 = (start2 + end2) / 2L;
        configurationFacade.registerRun(staticConfigProfile.getSubsystemName(), staticConfigProfile.getName(), staticConfigProfile.getTag(), start2);
        ConfigProfile engineeringProfile = Factories.copyProfile((ConfigProfile)staticConfigProfile, (String)"_engineering(config2)");
        Assert.assertNotNull((Object)engineeringProfile);
        configurationFacade.registerConfigProfile(engineeringProfile);
        Assert.assertTrue((engineeringProfile.getId() > 0L ? 1 : 0) != 0);
        configurationFacade.registerRun(engineeringProfile.getSubsystemName(), engineeringProfile.getName(), engineeringProfile.getTag(), start2 + 100L);
        ConfigProfile registeredProfileA = Factories.copyProfile((ConfigProfile)engineeringProfile, (String)"configNew");
        configurationFacade.registerConfigProfile(registeredProfileA);
        Assert.assertTrue((String)"id of profile should be positive", (registeredProfileA.getId() > 0L ? 1 : 0) != 0);
        configurationFacade.registerRun(registeredProfileA.getSubsystemName(), registeredProfileA.getName(), registeredProfileA.getTag(), end2);
        ConfigProfile cp = configurationFacade.getConfigRunningAt(subNameA, descriptionNameA, "", end2 + 200L);
        Assert.assertEquals((String)"registered profile should be running.", (Object)registeredProfileA.getName(), (Object)cp.getName());
        List res = configurationFacade.simpleHQLRequest("from GhostSubsystemDescription");
        System.out.println("GHOST= " + res);
        res = configurationFacade.simpleHQLRequest(" SELECT P FROM GhostSubsystemDescription G left join G.paramDescriptions as P WHERE G.id=1 AND P.simpleName='son//max'");
        Assert.assertEquals((String)"Description value : ", (Object)"1000", (Object)((ParameterDescription)res.get(0)).getParameterBase().getDefaultValue());
    }
}

