package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import org.hibernate.annotations.Immutable;

/**
 *
 * @author LSST CCS Team
 */
@Entity
@Immutable
@Cacheable
@org.hibernate.annotations.Cache( 
        usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_WRITE
        ,region = "org.lsst.ccs.localdb.statusdb.model.AgentState"
)
@NamedQueries ( {
    @NamedQuery (
            name = "findAgentState",
            query = "from AgentState ast where "
                    + "ast.agentDesc.agentName=:subsystemName "
                    + "and ast.baseState.id=:baseStateId ",
//                    + "and ast.innerStates=:innerStates ",
            hints = {@QueryHint(name="org.hibernate.cacheable", value="true")}
    )
})
@Table(
        indexes = {@Index(columnList = "agentName"),@Index(columnList = "baseStateId")}
)
public class AgentState implements Serializable {
    private static final long serialVersionUID = -8367786148299296222L;
    
    private long id;
    
    private AgentDesc agentDesc; 
    
    private BaseState baseState;
    
    private Map<String, InnerStateDesc> innerStates = new HashMap<>();

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne(optional = false)
    @JoinColumn(name="agentName")
    public AgentDesc getAgentDesc() {
        return agentDesc;
    }

    public void setAgentDesc(AgentDesc agentDesc) {
        this.agentDesc = agentDesc;
    }

    @ManyToOne(optional = false)
    public BaseState getBaseState() {
        return baseState;
    }

    public void setBaseState(BaseState baseState) {
        this.baseState = baseState;
    }

    @ManyToMany
    @MapKey(name = "enumClassName")
    public Map<String, InnerStateDesc> getInnerStates() {
        return innerStates;
    }

    public void setInnerStates(Map<String, InnerStateDesc> innerStates) {
        this.innerStates = innerStates;
    }
    
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(agentDesc.getAgentName());
        sb.append(":").append(baseState.toString()).append(",");
        for (InnerStateDesc isd : innerStates.values()) {
            sb.append(isd.toString()).append(",");
        }
        return sb.toString();
    }
    
}
