package org.lsst.ccs.localdb.configdb.model;


/**
 * An object which is warned when trying to copy a ParameterDescription
 * to a new SubsystemDescription that does not have a proper <TT>ParameterBase</TT>
 * to match.
 * @author bamade
 */
// Date: 25/04/12

public interface DescriptionMismatchListener {
    /**
     *
     * @param oldDesc description trying to be copied
     * @param newBase may be null otherwise a base that ddoes not fit
     * @param diag diagnosis of the problem (String or exception)
     */
    public void mismatch(ParameterDescription oldDesc, ParameterBase newBase, Object diag) ;
}
