/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.server;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.StateChange;
import org.lsst.ccs.localdb.statusdb.server.StateEvent;
import org.lsst.ccs.localdb.statusdb.server.StateInfo;
import org.lsst.ccs.localdb.statusdb.trendServer.RestServer;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.localdb.utils.MigrateAgentStates;

public class TrendServerTest
extends LocaldbTestTemplate {
    private static Map<Long, DataChannel> channels;
    private static WebResource serv;
    private static long tstart;
    private static long tstop;

    @BeforeClass
    public static void initClass() {
        p.setProperty("hibernate.dialect", "org.hibernate.dialect.HSQLDialect");
        p.setProperty("hibernate.connection.driver_class", "org.hsqldb.jdbcDriver");
        p.setProperty("hibernate.connection.url", "jdbc:hsqldb:file:target/test-classes/testtrendserverdb");
        p.setProperty("hibernate.connection.username", "root");
        p.setProperty("hibernate.connection.password", "");
        p.setProperty("hibernate.hbm2ddl.auto", "update");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        new RestServer(8080).start();
        Client client = Client.create((ClientConfig)new DefaultClientConfig());
        String restFullUrl = "http://localhost:8080/rest/data";
        serv = client.resource(restFullUrl).path("dataserver");
        channels = ((DataChannel.DataChannelList)TrendServerTest.serv.path((String)"listchannels").accept((String[])new String[]{"application/xml"}).get(DataChannel.DataChannelList.class)).list.stream().collect(Collectors.toMap(DataChannel::getId, c -> c));
        Session sess = sessionFactory.openSession();
        Object[] minMax = (Object[])sess.createQuery("select min(rd.time), max(rd.time) from RawData rd").uniqueResult();
        tstart = (Long)minMax[0];
        tstop = (Long)minMax[1];
        System.out.println("tstart : " + tstart + "; tstop : " + tstop);
        sess.close();
    }

    @Test
    public void testGetStateChanges() throws Exception {
        List states = ((StateInfo.StateInfoList)TrendServerTest.serv.path((String)"liststates/trendingSub").accept((String[])new String[]{"application/xml"}).get(StateInfo.StateInfoList.class)).stateInfoList;
        Assert.assertEquals((long)6L, (long)states.size());
        int margin = 10000;
        WebResource wrAll = serv.path("statechanges/trendingSub").queryParam("t1", String.valueOf(tstart - (long)margin)).queryParam("t2", String.valueOf(tstop + (long)margin));
        List allStateChanges = ((StateChange.StateChangesList)wrAll.accept((String[])new String[]{"application/xml"}).get(StateChange.StateChangesList.class)).list;
        Assert.assertEquals((long)8L, (long)allStateChanges.size());
        WebResource wrOne = wrAll.queryParam("state", "org.lsst.ccs.bus.states.PhaseState");
        List phaseStateChanges = ((StateChange.StateChangesList)wrOne.accept((String[])new String[]{"application/xml"}).get(StateChange.StateChangesList.class)).list;
        Assert.assertEquals((long)5L, (long)phaseStateChanges.size());
        WebResource wrTwo = wrOne.queryParam("state", "org.lsst.ccs.localdb.statusdb.TrendingPublisherAgent$State");
        List innerStateChanges = ((StateChange.StateChangesList)wrTwo.accept((String[])new String[]{"application/xml"}).get(StateChange.StateChangesList.class)).list;
        Assert.assertEquals((long)8L, (long)innerStateChanges.size());
        MigrateAgentStates.main(null);
        List listAfterMigration = ((StateChange.StateChangesList)wrAll.accept((String[])new String[]{"application/xml"}).get(StateChange.StateChangesList.class)).list;
        for (int i = 0; i < allStateChanges.size(); ++i) {
            List beforeStateEvents = ((StateChange)allStateChanges.get(i)).getStateEvents();
            List afterStateEvents = ((StateChange)listAfterMigration.get(i)).getStateEvents();
            Assert.assertEquals((long)beforeStateEvents.size(), (long)afterStateEvents.size());
            for (int j = 0; j < beforeStateEvents.size(); ++j) {
                StateEvent bSE = (StateEvent)beforeStateEvents.get(j);
                StateEvent aSE = (StateEvent)afterStateEvents.get(j);
                Assert.assertEquals((Object)bSE.componentName, (Object)aSE.componentName);
                Assert.assertEquals((Object)bSE.name, (Object)aSE.name);
                Assert.assertEquals((Object)bSE.value, (Object)aSE.value);
            }
        }
        Session sess = sessionFactory.openSession();
        int toMigrate = ((BigInteger)sess.createSQLQuery("select count(*) from ccs_agentSt_innerStDe_b").uniqueResult()).intValue();
        Assert.assertEquals((long)0L, (long)toMigrate);
    }
}

