/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.common;

import java.util.Properties;
import org.hibernate.SessionFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.lsst.ccs.localdb.statusdb.utils.CacheStatistics;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;

public class LocaldbTestTemplate
extends CcsTestCaseTemplate {
    protected static SessionFactory sessionFactory;
    protected static final Properties p;

    @BeforeClass
    public static void initSessionFactory() {
        p.setProperty("hibernate.dialect", "org.hibernate.dialect.HSQLDialect");
        p.setProperty("hibernate.connection.driver_class", "org.hsqldb.jdbcDriver");
        p.setProperty("hibernate.connection.url", "jdbc:hsqldb:mem:cache_size=200000");
        p.setProperty("hibernate.connection.username", "root");
        p.setProperty("hibernate.format_sql", "true");
        p.setProperty("hibernate.use_sql_comments", "true");
        p.setProperty("hibernate.show_sql", "true");
        p.setProperty("hibernate.hbm2ddl.auto", "create");
    }

    @After
    public void printQueryStatistics() {
        System.out.println(new CacheStatistics(sessionFactory).toString());
    }

    @AfterClass
    public static void closeSessionFactory() {
        StatusdbUtils.closeSessionFactory();
    }

    static {
        p = new Properties();
    }
}

