package org.lsst.ccs.localdb.utils;

import java.math.BigInteger;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.lsst.ccs.localdb.statusdb.model.AgentState;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.StateBundleDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.utilities.logging.Logger;

/**
 * Migration utility for AgentState entities.
 * It empties the AgentState#getInnerStates manyToMany association, and replaces it
 * by an entry in the map componentStates map, with the empty String as key.
 * 
 * @author LSST CCS Team
 */
public class MigrateAgentStates {
    
    private static Logger log = Logger.getLogger("org.lsst.ccs.localdb");
    
    public static void main(String[] args) throws SQLException {
    
        SessionFactory fac = StatusdbUtils.getSessionFactory(new Properties());
        
        Session sess = fac.openSession();
        
        SQLQuery somethingToMigrate = sess.createSQLQuery("select count(*) from ccs_agentSt_innerStDe_b");
        
        int toMigrate = ((BigInteger)somethingToMigrate.uniqueResult()).intValue();
        
        if(toMigrate == 0 ) {
            log.info("Nothing to migrate");
            sess.close();
        } else {
            log.info("There are " + toMigrate + " entries in the old bridge table to migrate");
            Transaction tx = sess.beginTransaction();
            List<AgentState> agentStates = sess.createQuery("from AgentState").list();

            for(AgentState as : agentStates) {
                Map<String, InnerStateDesc> isds = as.getInnerStates();
                if(!isds.isEmpty()) {
                    List<StateBundleDesc> sbds = sess.createQuery("from StateBundleDesc sbd where sbd.agentDesc=:ad").setEntity("ad", as.getAgentDesc()).list();
                    StateBundleDesc matchingSBD = null;
                    as.setInnerStates(new HashMap<>());
                    for(StateBundleDesc sbd : sbds) {
                        if(sbd.getComponentStates().equals(isds)) {
                            log.info("found matching StateBundleDesc for agent state " + as.getId());
                            matchingSBD = sbd;
                            break;
                        }
                    }
                    if(matchingSBD == null) {
                        log.info("no matching StateBundleDesc found for agent state " + as.getId() + " :  + creating it");
                        matchingSBD = new StateBundleDesc(as.getAgentDesc());
                        matchingSBD.setComponentStates(isds);
                        sess.persist(matchingSBD);
                    }
                    as.getComponentStates().put("", matchingSBD);
                }
                
            }
            tx.commit();
            sess.close();
        }
        
    }
    
    
}
