package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * An alert description.
 * @author LSST CCS Team
 */
@XmlRootElement(name="alertinfo")
public class AlertInfo implements Serializable {
    
    private static final long serialVersionUID = -3251661266965394032L;
    
    private long id;
    
    private String subsystemName;
    
    private String alertId;
    
    private String alertDescription;
    
    public AlertInfo() {
        
    }
    
    public AlertInfo(long id, String subsystemName, String alertId, String alertDescription) {
        this.id = id;
        this.subsystemName = subsystemName;
        this.alertId = alertId;
        this.alertDescription = alertDescription;
    }

    /**
     * The database id of the corresponding {@code AlertDesc}.
     * @return 
     */
    @XmlElement(name="id")
    public long getId() {
        return id;
    }

    @XmlElement(name="subsystemname")
    public String getSubsystemName() {
        return subsystemName;
    }

    @XmlElement(name="alertid")
    public String getAlertId() {
        return alertId;
    }
    @XmlElement(name="alertdescription")
    public String getAlertDescription() {
        return alertDescription;
    }
    
    @XmlRootElement(name = "alertsinfo")
    public static class AlertInfoList {
        
        @XmlElement(name = "alertinfo")
        private List<AlertInfo> list;
        
        public AlertInfoList() {
            
        }

        public AlertInfoList(List<AlertInfo> list) {
            this.list = list;
        }

        
    }
    
    
    
    
    
}
