package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;

/**
 *
 * @author The core states.
 */
@Entity
@Immutable
@Table(
        uniqueConstraints = @UniqueConstraint(columnNames = {"phaseState","operationalState","commandState","alertState","configState"}),
        indexes = {
            @Index(columnList = "phaseState"),
            @Index(columnList = "operationalState"),
            @Index(columnList = "alertState"),
            @Index(columnList = "commandState"),
            @Index(columnList = "configState")
        }
)
@Cacheable
@org.hibernate.annotations.Cache( 
        usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_WRITE
        ,region = "org.lsst.ccs.localdb.statusdb.model.BaseState"
)
@NamedQueries ( {
    @NamedQuery (
            name = "findBaseState",
            query = "from BaseState bs where "
                    + "bs.alertState=:alertSt and "
                    + "bs.configState=:configurationSt and "
                    + "bs.commandState=:commandSt and "
                    + "bs.operationalState=:operationalSt and "
                    + "bs.phaseState=:phaseSt",
            hints = {@QueryHint(name="org.hibernate.cacheable", value="true")}
    )
})
public class BaseState implements Serializable {
    
    private static final String UNDEFINED_STATE = "__UNDEF__";
    
    private static final long serialVersionUID = -6550418264821719859L;
    
    private long id;
    
    private String alertState;
    
    private String configState;
    
    private String phaseState;
    
    private String commandState;
    
    private String operationalState;

    public BaseState() {
        
    }
    
    public BaseState(StateBundle sb) {
        alertState = BaseState.getStateString(sb.getState(AlertState.class));
        phaseState = BaseState.getStateString(sb.getState(PhaseState.class));
        commandState = BaseState.getStateString(sb.getState(CommandState.class));
        operationalState = BaseState.getStateString(sb.getState(OperationalState.class));
        configState = BaseState.getStateString(sb.getState(ConfigurationState.class));
    }
    
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getAlertState() {
        return alertState;
    }

    public void setAlertState(String alertState) {
        this.alertState = alertState;
    }

    public String getConfigState() {
        return configState;
    }

    public void setConfigState(String configurationState) {
        this.configState = configurationState;
    }

    public String getPhaseState() {
        return phaseState;
    }

    public void setPhaseState(String phaseState) {
        this.phaseState = phaseState;
    }

    public String getCommandState() {
        return commandState;
    }

    public void setCommandState(String commandState) {
        this.commandState = commandState;
    }

    public String getOperationalState() {
        return operationalState;
    }

    public void setOperationalState(String operationalState) {
        this.operationalState = operationalState;
    }
    
    private static String getStateString(Enum state) {
        return state == null ? UNDEFINED_STATE : state.toString();
    }
    
    @Override
    public String toString() {
        return "PhaseState:"+phaseState+", OperationalState:"+operationalState
                +",CommandState:"+commandState+",AlertState:"+alertState
                +",ConfigState:"+configState;
    }
    
}
