/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.Statistics;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.localdb.dao.LocaldbFacade;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.model.AgentState;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.StateBundleDesc;
import org.lsst.ccs.localdb.statusdb.model.StateBundleExtender;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;

public class StatePersistenceTest
extends LocaldbTestTemplate {
    private final StateBundle baseSB1 = new StateBundle(new Enum[]{AlertState.NOMINAL, CommandState.READY, OperationalState.ENGINEERING_OK, PhaseState.INITIALIZING});
    private final StateBundle baseSB2 = new StateBundle(new Enum[]{AlertState.ALARM, CommandState.READY, OperationalState.ENGINEERING_FAULT, PhaseState.INITIALIZING, ConfigurationState.CONFIGURED});

    @BeforeClass
    public static void initClass() {
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
    }

    @Test
    public void testStateCaching() throws Exception {
        StatusdbUtils.closeSessionFactory();
        p.setProperty("hibernate.connection.url", "jdbc:hsqldb:mem::cache_size=200000");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        Session sess = sessionFactory.openSession();
        Statistics stats = sessionFactory.getStatistics();
        QueryStatistics baseStateStats = stats.getQueryStatistics(sess.getNamedQuery("findBaseState").getQueryString());
        QueryStatistics innerStateDescStats = stats.getQueryStatistics(sess.getNamedQuery("findInnerStateDesc").getQueryString());
        QueryStatistics agentStateStats = stats.getQueryStatistics(sess.getNamedQuery("findAgentState").getQueryString());
        sess.close();
        AgentInfo ai = new AgentInfo("agent_cachetest", AgentInfo.AgentType.WORKER);
        StateBundle sb1ReadyMotion = this.serdeser(new StateBundleExtender(this.baseSB1).setFilterState(true).setRotateState(true).getState());
        Assert.assertEquals((String)"there should be two states the class of which is unknown", (long)2L, (long)sb1ReadyMotion.getInternalStates().size());
        sess = sessionFactory.openSession();
        Transaction tx = sess.beginTransaction();
        AgentDesc ad = LocaldbFacade.getAgentDesc((AgentInfo)ai, (Session)sess);
        AgentState as = LocaldbFacade.getAgentState((AgentDesc)ad, (StateBundle)sb1ReadyMotion, (Session)sess);
        tx.commit();
        sess.close();
        Assert.assertEquals((String)"findBaseState hit count", (long)0L, (long)baseStateStats.getCacheHitCount());
        Assert.assertEquals((String)"findInnerStateDesc hit count", (long)0L, (long)innerStateDescStats.getCacheHitCount());
        Assert.assertEquals((String)"findAgentState hit count", (long)0L, (long)agentStateStats.getCacheHitCount());
        sess = sessionFactory.openSession();
        tx = sess.beginTransaction();
        as = LocaldbFacade.getAgentState((AgentDesc)ad, (StateBundle)sb1ReadyMotion, (Session)sess);
        tx.commit();
        sess.close();
        Assert.assertEquals((String)"findBaseState hit count", (long)0L, (long)baseStateStats.getCacheHitCount());
        Assert.assertEquals((String)"findInnerStateDesc hit count", (long)2L, (long)innerStateDescStats.getCacheHitCount());
        Assert.assertEquals((String)"findAgentState hit count", (long)0L, (long)agentStateStats.getCacheHitCount());
        sess = sessionFactory.openSession();
        tx = sess.beginTransaction();
        as = LocaldbFacade.getAgentState((AgentDesc)ad, (StateBundle)sb1ReadyMotion, (Session)sess);
        tx.commit();
        sess.close();
        Assert.assertEquals((String)"findBaseState hit count", (long)1L, (long)baseStateStats.getCacheHitCount());
        Assert.assertEquals((String)"findInnerStateDesc hit count", (long)6L, (long)innerStateDescStats.getCacheHitCount());
        Assert.assertEquals((String)"findAgentState hit count", (long)1L, (long)agentStateStats.getCacheHitCount());
    }

    @Test
    public void testStatePersistence() throws Exception {
        StatusdbUtils.closeSessionFactory();
        p.setProperty("hibernate.connection.url", "jdbc:hsqldb:mem::cache_size=200000");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        AgentInfo ai = new AgentInfo("agent_persistencetest", AgentInfo.AgentType.WORKER);
        StateBundle sb1ReadyMotion = this.serdeser(new StateBundleExtender(this.baseSB1).setFilterState(true).setRotateState(true).setComponentState("comp1", 0).getState());
        StateBundle sb1ReadyStationary = this.serdeser(new StateBundleExtender(this.baseSB1).setFilterState(true).setRotateState(false).setComponentState("comp2", 1).getState());
        StateBundle sb2NotReadyStationary = this.serdeser(new StateBundleExtender(this.baseSB2).setFilterState(false).setRotateState(false).setComponentState("comp3", 0).getState());
        Session sess = sessionFactory.openSession();
        Transaction tx = sess.beginTransaction();
        AgentDesc ad = LocaldbFacade.getAgentDesc((AgentInfo)ai, (Session)sess);
        LocaldbFacade.getAgentState((AgentDesc)ad, (StateBundle)sb1ReadyMotion, (Session)sess);
        LocaldbFacade.getAgentState((AgentDesc)ad, (StateBundle)sb1ReadyStationary, (Session)sess);
        LocaldbFacade.getAgentState((AgentDesc)ad, (StateBundle)sb2NotReadyStationary, (Session)sess);
        tx.commit();
        sess.close();
        sess = sessionFactory.openSession();
        tx = sess.beginTransaction();
        AgentState as1 = LocaldbFacade.getAgentState((AgentDesc)ad, (StateBundle)sb1ReadyMotion, (Session)sess);
        Map innerStates = ((StateBundleDesc)as1.getComponentStates().get("")).getComponentStates();
        Assert.assertEquals((long)2L, (long)innerStates.size());
        Assert.assertEquals((Object)"READY", (Object)((InnerStateDesc)innerStates.get("org.lsst.ccs.localdb.statusdb.model.StateBundleExtender$FilterReadinessState")).getEnumValue());
        Assert.assertEquals((Object)"IN_MOTION", (Object)((InnerStateDesc)innerStates.get("org.lsst.ccs.localdb.statusdb.model.StateBundleExtender$MotionState")).getEnumValue());
        StateBundleDesc comp1StateB = (StateBundleDesc)as1.getComponentStates().get("comp1");
        Assert.assertEquals((long)1L, (long)comp1StateB.getComponentStates().size());
        Assert.assertEquals((Object)"SUBSTATE_1", (Object)((InnerStateDesc)comp1StateB.getComponentStates().get("org.lsst.ccs.localdb.statusdb.model.StateBundleExtender$ComponentState")).getEnumValue());
        AgentState as2 = LocaldbFacade.getAgentState((AgentDesc)ad, (StateBundle)sb2NotReadyStationary, (Session)sess);
        innerStates = ((StateBundleDesc)as2.getComponentStates().get("")).getComponentStates();
        Assert.assertEquals((long)2L, (long)innerStates.size());
        Assert.assertEquals((Object)"NOT_READY", (Object)((InnerStateDesc)innerStates.get("org.lsst.ccs.localdb.statusdb.model.StateBundleExtender$FilterReadinessState")).getEnumValue());
        Assert.assertEquals((Object)"STATIONARY", (Object)((InnerStateDesc)innerStates.get("org.lsst.ccs.localdb.statusdb.model.StateBundleExtender$MotionState")).getEnumValue());
        StateBundleDesc comp3StateB = (StateBundleDesc)as2.getComponentStates().get("comp3");
        Assert.assertEquals((String)"ids should be equal", (long)comp1StateB.getId(), (long)comp3StateB.getId());
        tx.commit();
        sess.close();
    }

    @Test
    public void testMultipleSameStatePersistenceSameSession() throws Exception {
        int i;
        StatusdbUtils.closeSessionFactory();
        p.setProperty("hibernate.connection.url", "jdbc:hsqldb:file:target/test-classes/teststates");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        AgentInfo ai = new AgentInfo("agent_persistencetest", AgentInfo.AgentType.WORKER);
        StateBundleExtender sbe1 = new StateBundleExtender(this.baseSB1).setFilterState(true).setRotateState(true);
        for (i = 0; i < 50; ++i) {
            sbe1.setComponentState("comp" + i, 0);
        }
        for (i = 50; i < 100; ++i) {
            sbe1.setComponentState("comp" + i, 1);
        }
        StateBundle sb1ReadyMotion = this.serdeser(sbe1.getState());
        Session sess = sessionFactory.openSession();
        Transaction tx = sess.beginTransaction();
        AgentDesc ad = LocaldbFacade.getAgentDesc((AgentInfo)ai, (Session)sess);
        LocaldbFacade.getAgentState((AgentDesc)ad, (StateBundle)sb1ReadyMotion, (Session)sess);
        tx.commit();
        sess.close();
        sess = sessionFactory.openSession();
        List isdl = sess.createQuery("from InnerStateDesc").list();
        Assert.assertEquals((String)isdl.toString(), (long)4L, (long)isdl.size());
        List sbdl = sess.createQuery("from StateBundleDesc").list();
        Assert.assertEquals((long)3L, (long)sbdl.size());
        List asl = sess.createQuery("from AgentState").list();
        Assert.assertEquals((long)1L, (long)asl.size());
        sess.close();
    }

    private StateBundle serdeser(StateBundle sb) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(sb);
        byte[] bytes = bos.toByteArray();
        out.close();
        bos.close();
        StateBundle res = (StateBundle)new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        return res;
    }
}

