/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.configdb.dao;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.localdb.configdb.model.Configuration;
import org.lsst.ccs.localdb.configdb.model.ConfigurationParameter;
import org.lsst.ccs.localdb.configdb.model.ConfigurationRun;
import org.lsst.ccs.localdb.configdb.model.Description;
import org.lsst.ccs.localdb.configdb.model.GlobalConfiguration;
import org.lsst.ccs.localdb.configdb.model.HibernateDAO;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.utilities.structs.ParameterPath;

public class ConfigHibernateTest
extends LocaldbTestTemplate {
    private static HibernateDAO dbInterface;

    @BeforeClass
    public static void setupClass() throws Exception {
        System.setProperty("hsqldb.reconfig_logging", "true");
        System.setProperty("org.jboss.logging.provider", "jdk");
        Logger.getLogger("hsqldb.db").setLevel(Level.OFF);
        Logger.getLogger("org.hibernate").setLevel(Level.OFF);
        Logger.getLogger("org.jboss").setLevel(Level.OFF);
        p.setProperty("hibernate.use_sql_comments", "false");
        p.setProperty("hibernate.show_sql", "false");
        p.setProperty("hibernate.format_sql", "false");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        dbInterface = new HibernateDAO(sessionFactory);
    }

    @Before
    public void init() {
    }

    @Test
    public void testScenarios() throws Exception {
        dbInterface.begin();
        AgentDesc ad = new AgentDesc(new AgentInfo("someName", AgentInfo.AgentType.WORKER));
        dbInterface.persist((Object)ad);
        ConfigurationInfo.Builder cib = new ConfigurationInfo.Builder();
        ConfigurationInfo ci = cib.addParameter(ParameterPath.valueOf((String)"main/info"), "java.lang.String", "catA", "", false).updateParameter(ParameterPath.valueOf((String)"main/info"), "info", "info", false).addParameter(ParameterPath.valueOf((String)"main/max"), "java.lang.Integer", "catA", "", false).addParameter(ParameterPath.valueOf((String)"son/max"), "java.lang.Integer", "catA", "", false).build();
        Description descA = dbInterface.findDescriptionOrCreate(ad, ci.getAllParameterInfo());
        Assert.assertNotEquals((String)"size of parameter description should be >0", (long)0L, (long)descA.getConfigurationParameters().size());
        Assert.assertNotNull((Object)descA);
        long descAId = descA.getId();
        Assert.assertTrue((String)"id of subsystem description should be > 0", (descA.getId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((String)"number of attached configuration parameters : ", (long)3L, (long)descA.getConfigurationParameters().size());
        Description sameDescA = dbInterface.findDescriptionOrCreate(ad, ci.getAllParameterInfo());
        Assert.assertEquals((long)descA.getId(), (long)sameDescA.getId());
        ci = new ConfigurationInfo.Builder().addParameter(ParameterPath.valueOf((String)"main/info"), "java.lang.String", "", "", false).updateParameter(ParameterPath.valueOf((String)"main/info"), "info", "info", false).addParameter(ParameterPath.valueOf((String)"main/max"), "java.lang.Integer", "catA", "", false).addParameter(ParameterPath.valueOf((String)"son/max"), "java.lang.Integer", "catB", "", false).build();
        Description descB = dbInterface.findDescriptionOrCreate(ad, ci.getAllParameterInfo());
        Assert.assertTrue((String)"id of subsystem description should be > 0", (descB.getId() > 0L ? 1 : 0) != 0);
        Assert.assertNotEquals((String)"the description entity should be different", (long)descA.getId(), (long)descB.getId());
        long t0 = System.currentTimeMillis();
        Configuration config = dbInterface.getConfigurationOrCreate(descA, "configA1", "catA", -3, ci.getAllParameterInfo(), t0, null);
        ConfigurationRun run = new ConfigurationRun(config, t0);
        dbInterface.populateRunFromScratch(run, Collections.emptyList());
        Assert.assertNotNull((Object)dbInterface.getConfigurationOrNull(descA, "configA1", "catA", 0));
        HashSet distinctCP = new HashSet();
        distinctCP.addAll(descA.getConfigurationParameters().values().stream().map(ConfigurationParameter::getId).collect(Collectors.toSet()));
        distinctCP.addAll(descB.getConfigurationParameters().values().stream().map(ConfigurationParameter::getId).collect(Collectors.toSet()));
        Assert.assertEquals((String)("number of distinct configuration parameters : " + distinctCP), (long)5L, (long)distinctCP.size());
        long t1 = t0 + 300L;
        cib.updateParameter(ParameterPath.valueOf((String)"main/max"), "0", "2000", true).addRecentChange("main/max");
        ConfigurationRun nextRun = new ConfigurationRun(config, t1);
        nextRun = dbInterface.populateRunFromPreviousRun(run, nextRun, cib.build().getLatestChanges());
        long t2 = t1 + 300L;
        cib.updateParameter(ParameterPath.valueOf((String)"son/max"), "0", "3000", true).addRecentChange("son/max");
        ConfigurationRun nextRun2 = new ConfigurationRun(config, t2);
        nextRun2 = dbInterface.populateRunFromPreviousRun(nextRun, nextRun2, cib.build().getLatestChanges());
        long t3 = t2 + 300L;
        Configuration config2 = dbInterface.getConfigurationOrCreate(descA, "configA2", "catA", -3, cib.build().getAllParameterInfo(), t3, nextRun2);
        Assert.assertEquals((long)0L, (long)config2.getVersion());
        ConfigurationRun nextRun3 = new ConfigurationRun(config2, t3);
        nextRun3 = dbInterface.populateRunFromPreviousRun(nextRun2, nextRun3, Collections.emptyList());
        long t4 = t3 + 300L;
        cib.updateParameter(ParameterPath.valueOf((String)"main/max"), "0", "4000", true).addRecentChange("main/max");
        ConfigurationRun nextRun4 = new ConfigurationRun(config2, t4);
        nextRun4 = dbInterface.populateRunFromPreviousRun(nextRun3, nextRun4, cib.build().getLatestChanges());
        long t5 = t4 + 300L;
        cib.updateParameter(ParameterPath.valueOf((String)"main/max"), "4000", "4000", false);
        Configuration config2bis = dbInterface.getConfigurationOrCreate(descA, "configA2", "catA", -3, cib.build().getAllParameterInfo(), t5, nextRun4);
        Assert.assertEquals((long)1L, (long)config2bis.getVersion());
        ConfigurationRun nextRun5 = new ConfigurationRun(config2bis, t5);
        nextRun5 = dbInterface.populateRunFromPreviousRun(nextRun4, nextRun5, cib.build().getLatestChanges());
        dbInterface.end();
        dbInterface.begin();
        descA = dbInterface.getDescription(descAId);
        ConfigurationRun activeRun = dbInterface.getActiveConfigurationRun(descA, "catA");
        Assert.assertNotNull((String)"there should be an active configuration run", (Object)activeRun);
        dbInterface.end();
        dbInterface.begin();
        descA = dbInterface.getDescription(descAId);
        dbInterface.endRun(descA, t4 + 300L);
        dbInterface.begin();
        descA = dbInterface.getDescription(descAId);
        activeRun = dbInterface.getActiveConfigurationRun(descA, "catA");
        Assert.assertNull((String)"there should not be an active run", (Object)activeRun);
        dbInterface.end();
        dbInterface.begin();
        Configuration c = dbInterface.getConfigurationOrNull(descA, "configA2", "catA", -1);
        Assert.assertEquals((long)config2bis.getId(), (long)c.getId());
        Assert.assertTrue((boolean)c.isLatestVersion());
        dbInterface.end();
        dbInterface.begin();
        HashMap<String, Configuration> map = new HashMap<String, Configuration>();
        map.put(config2.getCategory(), config);
        GlobalConfiguration gc = dbInterface.findGlobalConfigurationOrCreate(descA, "global_1", map);
        Assert.assertNotNull((Object)gc);
        Assert.assertEquals((long)0L, (long)gc.getVersion());
        dbInterface.end();
        dbInterface.begin();
        map.put(config2bis.getCategory(), config2bis);
        GlobalConfiguration gc2 = dbInterface.findGlobalConfigurationOrCreate(descA, "global_1", map);
        Assert.assertEquals((long)1L, (long)gc2.getVersion());
        dbInterface.end();
    }
}

